<?php
$requestUri = $_SERVER['REQUEST_URI'];
$requestUrl = $_SERVER['REDIRECT_URL'];
$requestMethod = $_SERVER['REQUEST_METHOD'];
// $httpReferer = isset($_SERVER['HTTP_APP_VERSION']) ? $_SERVER['HTTP_APP_VERSION'] : "";
// $access_token = $_SERVER['REQUEST_METHOD'];
// $token_type = $_SERVER['REQUEST_METHOD'];
// $client = $_SERVER['REQUEST_METHOD'];
// $expiry = $_SERVER['REQUEST_METHOD'];
// //print_r($_POST);
//print_r($_SERVER);
//die;
//echo $uid;

switch ($requestUrl) {
    case '/auth/sign_in':
        if ($requestMethod == 'POST') {
            $data = !empty($_POST) ? $_POST : $_SERVER;
            require_once __DIR__ . '/../controllers/AuthController.php';
            $authController = new AuthController();
            $authController->signIn($data);
        }
        exit;
    case '/auth/sign_out':
        if ($requestMethod == 'DELETE') {
            $data = $_SERVER;
            require_once __DIR__ . '/../controllers/AuthController.php';
            $authController = new AuthController();
            $authController->signOut($data);
        }
        exit;
    case (preg_match('/\/users\/\d+/', $requestUri) ? true : false):
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/UsersController.php';
            $controller = new UsersController();
            $id = basename($requestUri);
            $controller->getUserById($id);
        }
        exit;
}

// if ($httpReferer == "") {
//     http_response_code(403); // Forbidden
//     echo "Authencation faild!";
//     exit();
// }


switch ($requestUrl) {
    case preg_match('/^\/interventions\/\d+\/(photos)$/', $requestUrl) && $requestMethod == 'POST':
        $parts = explode('/', trim($requestUrl, '/'));
        $Id = $parts[1];
        require_once __DIR__ . '/../controllers/InterventionsController.php';
        $controller = new InterventionsController();
        $controller->uploadPhoto($Id);
        break;
    case (preg_match('/\/interventions\/\d+/', $requestUrl) ? true : false):
        if ($requestMethod == 'GET') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/OpenInterventionsController.php';
            $controller = new OpenInterventionsController();
            $controller->getInterventionById($id);
        } else if ($requestMethod == 'PUT') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/OpenInterventionsController.php';
            $controller = new OpenInterventionsController();
            $controller->updateReport($id);
        } else if ($requestMethod == 'PATCH') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/OpenInterventionsController.php';
            $controller = new OpenInterventionsController();
            $controller->update($id);
        } else if ($requestMethod == 'DELETE') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/OpenInterventionsController.php';
            $controller = new OpenInterventionsController();
            $controller->distroy($id);
        }
        break;
    case '/intervention_events':
        if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/InterventionsController.php';
            $openInterventionsController = new InterventionsController();
            $openInterventionsController->createEvent();
        }
        break;
    case '/interventions':
        if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/InterventionsController.php';
            $openInterventionsController = new InterventionsController();
            $openInterventionsController->create();
        }
        break;
    case '/open_interventions':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/OpenInterventionsController.php';
            $openInterventionsController = new OpenInterventionsController();
            $openInterventionsController->index();
        }
        break;
    case '/closed_interventions':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/ClosedInterventionsController.php';
            $controller = new ClosedInterventionsController();
            $controller->index();
        }
        break;
    case '/waiting_interventions':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/WaitingInterventionsController.php';
            $controller = new WaitingInterventionsController();
            $controller->index();
        }
        break;
    case '/refused_interventions':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/RefusedInterventionsController.php';
            $controller = new RefusedInterventionsController();
            $controller->index();
        }
        break;
    case '/notes':
        // if ($requestMethod == 'GET') {
        //     require_once __DIR__ . '/../controllers/InterventionsController.php';
        //     $controller = new InterventionsController();
        //     $controller->index();
        // } else 
        if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/InterventionsController.php';
            $controller = new InterventionsController();
            $controller->createNote();
        }
        break;
    case '/plants':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/PlantsController.php';
            $controller = new PlantsController();
            $controller->index();
        } else if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/PlantsController.php';
            $controller = new PlantsController();
            $controller->Create();
        }
        break;
    case preg_match('/^\/plants\/\d+\/(plant_photos)$/', $requestUrl) && $requestMethod == 'POST':
        $parts = explode('/', trim($requestUrl, '/'));
        $plantId = $parts[1];
        require_once __DIR__ . '/../controllers/PlantsController.php';
        $controller = new PlantsController();
        $controller->uploadPlanPhoto($plantId);
        break;
    case preg_match('/^\/plants\/\d+\/(deadlines|closed_interventions)$/', $requestUrl) && $requestMethod == 'GET':
        $parts = explode('/', trim($requestUrl, '/'));
        $plantId = $parts[1];  // Technician ID
        $interventionType = $parts[2];  // Type of intervention
        // // Call the appropriate method based on the intervention type
        switch ($interventionType) {
            case 'deadlines':
                require_once __DIR__ . '/../controllers/plants/DeadlinesController.php';
                $controller = new DeadlinesController();
                $controller->getPlantsByIdDeadlines($plantId);
                break;
            case 'closed_interventions':
                // require_once __DIR__ . '/../controllers/PlantsController.php';
                // $controller = new PlantsController();
                // $controller->getPlantsByIdClosedInterventions($plantId);
                //echo "getPlantsByIdClosedInterventions";
                require_once __DIR__ . '/../controllers/ClosedInterventionsController.php';
                $controller = new ClosedInterventionsController();
                $controller->getPlantsByIdClosedInterventions($plantId);
                break;
        }
        break;
    case preg_match('/^\/plants\/\d+\/(appointments|visits)$/', $requestUrl) && $requestMethod == 'POST':
        $parts = explode('/', trim($requestUrl, '/'));
        $plantId = $parts[1];
        $interventionType = $parts[2];
        require_once __DIR__ . '/../controllers/PlantsController.php';
        $controller = new PlantsController();
        $controller->createAppointment($plantId);
        break;
    case preg_match('/^\/plants\/\d+\/(appointments|visits)$/', $requestUrl) && $requestMethod == 'GET':
        $parts = explode('/', trim($requestUrl, '/'));
        $plantId = $parts[1];
        $deadlineType = $parts[2];
        require_once __DIR__ . '/../controllers/plants/DeadlinesController.php';
        $controller = new DeadlinesController();
        $controller->getDeadlinesByPlantId($plantId, $deadlineType);
        break;
    case preg_match('/^\/appointments\/\d+/', $requestUrl) && $requestMethod == 'DELETE':
        $parts = explode('/', trim($requestUrl, '/'));
        $id = $parts[1];
        require_once __DIR__ . '/../controllers/PlantsController.php';
        $controller = new PlantsController();
        $controller->distroyDeadline($id);
        break;
    case preg_match('/^\/visits\/\d+/', $requestUrl) && $requestMethod == 'DELETE':
        $parts = explode('/', trim($requestUrl, '/'));
        $id = $parts[1];
        require_once __DIR__ . '/../controllers/PlantsController.php';
        $controller = new PlantsController();
        $controller->distroyDeadline($id);
        break;
    case (preg_match('/\/plants\/\d+/', $requestUrl) ? true : false):
        if ($requestMethod == 'GET') {
            $parts = explode('/', trim($requestUrl, '/'));
            $plantId = $parts[1];
            require_once __DIR__ . '/../controllers/PlantsController.php';
            $controller = new PlantsController();
            $controller->getPlantsById($plantId);
        } else if ($requestMethod == 'PATCH') {
            $parts = explode('/', trim($requestUrl, '/'));
            $plantId = $parts[1];
            require_once __DIR__ . '/../controllers/PlantsController.php';
            $controller = new PlantsController();
            $controller->update($plantId);
        } else if ($requestMethod == 'DELETE') {
            $parts = explode('/', trim($requestUrl, '/'));
            $plantId = $parts[1];
            require_once __DIR__ . '/../controllers/PlantsController.php';
            $controller = new PlantsController();
            $controller->distroy($plantId);
        }
        break;
    case '/visits':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/VisitsController.php';
            $controller = new VisitsController();
            $controller->index();
        }
        break;

    case preg_match('/^\/technicians\/\d+\/(open_interventions|closed_interventions|waiting_interventions)$/', $requestUrl) && $requestMethod == 'GET':
        $parts = explode('/', trim($requestUrl, '/'));
        $technicianId = $parts[1];  // Technician ID
        $interventionType = $parts[2];  // Type of intervention
        // // Call the appropriate method based on the intervention type
        switch ($interventionType) {
            case 'open_interventions':
                require_once __DIR__ . '/../controllers/technicians/OpenInterventionsController.php';
                $controller = new OpenInterventionsController();
                // Extract the technician ID and the type of intervention
                $only_support = isset($_GET['only_support']) ? $_GET['only_support'] : "false";
                if ($only_support == 'true') {
                    $controller->getOpenInterventionsOnlySupport($technicianId);
                } else {
                    $controller->getOpenInterventions($technicianId);
                }

                break;
            case 'closed_interventions':
                require_once __DIR__ . '/../controllers/technicians/ClosedInterventionsController.php';
                $controller = new ClosedInterventionsController();
                // Extract the technician ID and the type of intervention
                $controller->getClosedInterventions($technicianId);
                break;
        }
        break;
    case '/technician_levels':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/TechniciansController.php';
            $controller = new TechniciansController();
            $controller->getTechnicianlevels();
        }
        if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/TechniciansController.php';
            $controller = new TechniciansController();
            $controller->createLevel();
        }
        break;
    case (preg_match('/\/technician_levels\/\d+/', $requestUrl) ? true : false):
        if ($requestMethod == 'DELETE') {
            require_once __DIR__ . '/../controllers/TechniciansController.php';
            $controller = new TechniciansController();
            $parts = explode('/', trim($requestUrl, '/'));
            $levelId = $parts[1];  // Technician ID
            $controller->distroyLevel($levelId);
        }
        break;
    case preg_match('/^\/technicians\/\d+$/', $requestUrl) && $requestMethod == 'GET':
        require_once __DIR__ . '/../controllers/TechniciansController.php';
        $controller = new TechniciansController();
        $parts = explode('/', trim($requestUrl, '/'));
        $technicianId = $parts[1];  // Technician ID
        $controller->getTechnicianById($technicianId);
        break;
    case preg_match('/^\/technicians\/\d+$/', $requestUrl) && $requestMethod == 'PATCH':
        require_once __DIR__ . '/../controllers/TechniciansController.php';
        $controller = new TechniciansController();
        $parts = explode('/', trim($requestUrl, '/'));
        $technicianId = $parts[1];  // Technician ID
        $controller->update($technicianId);
        break;
    case preg_match('/^\/technicians\/\d+$/', $requestUrl) && $requestMethod == 'DELETE':
        require_once __DIR__ . '/../controllers/TechniciansController.php';
        $controller = new TechniciansController();
        $parts = explode('/', trim($requestUrl, '/'));
        $technicianId = $parts[1];  // Technician ID
        $controller->distroy($technicianId);
        break;
    case '/technicians':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/TechniciansController.php';
            $controller = new TechniciansController();
            $controller->index();
        } else if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/TechniciansController.php';
            $controller = new TechniciansController();
            $controller->create();
        }
        break;
    case (preg_match('/\/technicians\/\d+/', $requestUrl) ? true : false):
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/plants/DeadlinesController.php';
            $controller = new DeadlinesController();
            $parts = explode('/', trim($requestUrl, '/'));
            $technicianId = $parts[1];  // Technician ID
            $deadlines = $parts[2];  // Type of intervention
            $controller->technicianDeadline($technicianId);
        }
        break;
    case (preg_match('/\/deadlines\/\d+/', $requestUrl) ? true : false):
        if ($requestMethod == 'GET') {
            $parts = explode('/', trim($requestUrl, '/'));
            $deadLineId = $parts[1];  // Technician ID
            require_once __DIR__ . '/../controllers/plants/DeadlinesController.php';
            $controller = new DeadlinesController();
            $controller->getDeadlineById($deadLineId);
        }
        break;
    case '/deadlines':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/plants/DeadlinesController.php';
            $controller = new DeadlinesController();
            $controller->index();
        }
        break;
    case '/issues':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/IssueController.php';
            $controller = new IssueController();
            $controller->index();
        }
        if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/IssueController.php';
            $controller = new IssueController();
            $controller->create();
        }
        break;
    case '/admins':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/AdminsController.php';
            $controller = new AdminsController();
            $controller->index();
        } else if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/AdminsController.php';
            $controller = new AdminsController();
            $controller->create();
        }
        break;

    case (preg_match('/\/admins\/\d+/', $requestUri) ? true : false):
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/AdminsController.php';
            $controller = new AdminsController();
            $id = basename($requestUri);
            $controller->getUserById($id);
        } else if ($requestMethod == 'PATCH') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/AdminsController.php';
            $controller = new AdminsController();
            $controller->update($id);
        } else if ($requestMethod == 'DELETE') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/AdminsController.php';
            $controller = new AdminsController();
            $controller->distroy($id);
        }
        break;
    case '/companyadmins':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/CompanyAdminsController.php';
            $controller = new CompanyAdminsController();
            $controller->index();
        } else if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/CompanyAdminsController.php';
            $controller = new CompanyAdminsController();
            $controller->create();
        }
        break;
    case (preg_match('/\/companyadmins\/\d+/', $requestUri) ? true : false):
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/CompanyAdminsController.php';
            $controller = new CompanyAdminsController();
            $id = basename($requestUri);
            $controller->getUserById($id);
        } else if ($requestMethod == 'PATCH') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/CompanyAdminsController.php';
            $controller = new CompanyAdminsController();
            $controller->update($id);
        } else if ($requestMethod == 'DELETE') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/CompanyAdminsController.php';
            $controller = new CompanyAdminsController();
            $controller->distroy($id);
        }
        break;
    case '/companies':
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/CompaniesController.php';
            $controller = new CompaniesController();
            $controller->index();
        } else if ($requestMethod == 'POST') {
            require_once __DIR__ . '/../controllers/CompaniesController.php';
            $controller = new CompaniesController();
            $controller->create();
        }
        break;

    case preg_match('/^\/companies\/\d+\/(admins|technicians)$/', $requestUrl) && $requestMethod == 'GET':
        $parts = explode('/', trim($requestUrl, '/'));
        $companyId = $parts[1];  // Technician ID
        $userType = $parts[2];  // Type of intervention
        // // Call the appropriate method based on the intervention type
        switch ($userType) {
            case 'admins':
                require_once __DIR__ . '/../controllers/CompaniesController.php';
                $controller = new CompaniesController();
                $controller->getUsersByCompanyId($companyId, 'admin');
                break;
            case 'technicians':
                require_once __DIR__ . '/../controllers/CompaniesController.php';
                $controller = new CompaniesController();
                // Extract the technician ID and the type of intervention
                $controller->getUsersByCompanyId($companyId, 'technician');
                break;
        }
        break;
    case (preg_match('/\/companies\/\d+/', $requestUri) ? true : false):
        if ($requestMethod == 'GET') {
            require_once __DIR__ . '/../controllers/CompaniesController.php';
            $controller = new CompaniesController();
            $id = basename($requestUri);
            $controller->getCompanyById($id);
        } else if ($requestMethod == 'PATCH') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/CompaniesController.php';
            $controller = new CompaniesController();
            $controller->update($id);
        } else if ($requestMethod == 'DELETE') {
            $parts = explode('/', trim($requestUrl, '/'));
            $id = $parts[1];
            require_once __DIR__ . '/../controllers/CompaniesController.php';
            $controller = new CompaniesController();
            $controller->distroy($id);
        }
        break;

    // default:
    //     http_response_code(404);
    //     echo json_encode(['message' => 'Not Found']);
    //     break;
}

// $authController = new AuthController();
// //if ($_SERVER['REQUEST_METHOD'] === 'POST' || $_SERVER['REQUEST_METHOD'] === 'post') {
// if ($_SERVER) {
//     //if (isset($_GET['app_version']) && $_GET['app_version'] === '0.2.1') {
//     // if (isset($_GET['app_version'])) {
//     $authController->signIn($_SERVER);
//     // } else {
//     //     echo json_encode(['error' => 'Invalid app version']);
//     // }
// } else {
//     echo json_encode(['error' => 'Invalid request method']);
// }

// $openInterventionsController = new OpenInterventionsController();
// if ($_SERVER) {

//     $openInterventionsController->index($_SERVER);
// } else {
//     echo json_encode(['error' => 'Invalid request method']);
// }