<?php
require_once __DIR__ . '/../../helpers/response.php';
// require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../BaseController.php';

class DeadlinesController extends BaseController
{
    // private $pdo;

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $goObject = $this->currentUserGOPosition;
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;
        $typology = isset($_GET['typology']) ? $_GET['typology'] : '';

        // $typeToSearch = '';
        // switch ($params['typology']) {
        //     case 'open':
        //         $typeToSearch = 'Open';
        //         break;
        //     case 'closed':
        //         $typeToSearch = 'Closed';
        //         break;
        // }

        // Building SQL Query
        $querySQL = "
            SELECT 
            d.*, 
            DATE_FORMAT(d.closed_at, '%d/%m/%Y %H:%i:%s') AS d_closed_at,
            DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS d_date,
            t.id AS technician_id, 
            t.name AS technician_name, 
            t.surname AS technician_surname, 
            t.type AS technician_type,
            plant.id AS plant_id,
            plant.street AS plant_street,
            plant.number AS plant_number,
            plant.cap AS plant_cap,
            plant.city AS plant_city,
            plant.country AS plant_country,
            plant.contract AS plant_contract,
            plant.matriculation AS plant_matriculation,
            plant.code AS plant_code,
            plant.latitude AS plant_latitude,
            plant.longitude AS plant_longitude
            FROM deadlines d
            LEFT JOIN users t ON d.current_technician_id = t.id
            LEFT JOIN plants plant ON d.plant_id = plant.id
            WHERE d.company_id=:company_id
            order by d.id desc
            LIMIT :limit OFFSET :offset
        ";

        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 

        // $statement->bindValue(':support_technicianId', $technicianId, PDO::PARAM_INT);
        // $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        //$statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                "id" => $row['id'],
                "closed_at" => $row['d_closed_at'],
                "title" => $row['title'],
                "type" => $row['type'],
                "current_technician" => [
                    "id" => $row['technician_id'],
                    "name" => $row['technician_name'],
                    "surname" => $row['technician_surname'],
                    "type" => $row['technician_type'],
                ],
                "date" => $row['d_date'],
                "distance" => null,
                "model_type" => '',
                "notes" => [
                ],
                "overdue" => true,
                "periodicity" => $row['periodicity'],
                "plant" => [
                    "address" => $row['plant_street'] . " " . $row['plant_number'] . ", " . $row['plant_cap'] . " " . $row['plant_city'] . ", " . $row['plant_city'] . ", " . $row['plant_country'],
                    "cap" => $row['plant_cap'],
                    "city" => $row['plant_city'],
                    "code" => $row['plant_code'],
                    "contract" => $row['plant_contract'],
                    "detail" => "",
                    "id" => $row['plant_id'],
                    "matriculation" => $row['plant_matriculation'],
                    "number" => $row['plant_number'],
                    "street" => $row['plant_street'],
                    "streetview_url" => ""
                ],


            ];

            $plant_latitude = $row['plant_latitude'];
            $plant_longitude = $row['plant_longitude'];


            if ($goObject && $plant_latitude && $plant_longitude) {
                $user_latitude = $goObject['latitude'];
                $user_longitude = $goObject['longitude'];

                $latitudeFrom = $user_latitude;
                $longitudeFrom = $user_longitude;
                $latitudeTo = $plant_latitude;
                $longitudeTo = $plant_longitude;
                $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
                $intervention['distance'] = $distance;
            }

            // Append the intervention to the interventions array
            $interventions[] = $intervention;
        }
        // Convert the array to JSON
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;

        // if (!is_null($params['expired'])) {
        //     if ($params['typology'] == 'closed') {
        //         if ($params['expired'] == 'true') {
        //             $query .= " AND DATE(d.date) < DATE(d.created_at)";
        //         } else {
        //             $query .= " AND DATE(d.date) >= DATE(d.created_at)";
        //         }
        //     } else {
        //         if ($params['expired'] == 'true') {
        //             $query .= " AND DATE(d.date) <= NOW()";
        //         } else {
        //             $query .= " AND DATE(d.date) > NOW()";
        //         }
        //     }
        // }

        // $statement = $this->pdo->prepare($query);
        // $statement->bindValue(':type1', '%' . $typeToSearch . 'MaintenanceVisit%', PDO::PARAM_STR);
        // $statement->bindValue(':type2', '%' . $typeToSearch . 'SemiannualVisit%', PDO::PARAM_STR);
        // $statement->bindValue(':type3', '%' . $typeToSearch . 'Appointment%', PDO::PARAM_STR);
        // $statement->bindValue(':plant_id', $plant_id, PDO::PARAM_INT);
        // $statement->execute();
        // $deadlines = $statement->fetchAll(PDO::FETCH_ASSOC);

        // // Sorting by distance or date if required
        // if (isset($params['sort_by_distance']) && $params['technician_id']) {
        //     $lastTechPosition = $this->getLastTechnicianPosition($params['technician_id']);
        //     if ($lastTechPosition) {
        //         foreach ($deadlines as &$deadline) {
        //             $distance = $this->calculateDistance(
        //                 $lastTechPosition['latitude'],
        //                 $lastTechPosition['longitude'],
        //                 $deadline['latitude'],
        //                 $deadline['longitude']
        //             );
        //             $deadline['distance'] = $distance;
        //         }

        //         if ($params['sort_by_distance'] == 'true') {
        //             usort($deadlines, function ($a, $b) {
        //                 return $a['distance'] <=> $b['distance'];
        //             });
        //         }
        //     }
        // } elseif (isset($params['sort_by_date']) && $params['sort_by_date'] == 'closing') {
        //     usort($deadlines, function ($a, $b) {
        //         return strtotime($b['closed_at']) <=> strtotime($a['closed_at']);
        //     });
        // }

        // // Handle pagination
        // if ($params['typology'] == 'open') {
        //     $this->renderJson(['deadlines' => $deadlines, 'distances' => null], 200);
        // } else {
        //     $paginatedDeadlines = $this->paginate($deadlines, $params['page'], 10);
        //     $this->renderJson(['deadlines' => $paginatedDeadlines, 'distances' => null], 200);
        // }
    }

    public function technicianDeadline($technicianId)
    {
        $goObject = $this->currentUserGOPosition;
        //$companyObject = $this->currentUserCompany;
        //  $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;
        $typology = isset($_GET['typology']) ? $_GET['typology'] : '';

        // $typeToSearch = '';
        // switch ($params['typology']) {
        //     case 'open':
        //         $typeToSearch = 'Open';
        //         break;
        //     case 'closed':
        //         $typeToSearch = 'Closed';
        //         break;
        // }

        // Building SQL Query
        $querySQL = "
            SELECT 
            d.*, 
            DATE_FORMAT(d.closed_at, '%d/%m/%Y %H:%i:%s') AS d_closed_at,
            DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS d_date,
            t.id AS technician_id, 
            t.name AS technician_name, 
            t.surname AS technician_surname, 
            t.type AS technician_type,
            plant.id AS plant_id,
            plant.street AS plant_street,
            plant.number AS plant_number,
            plant.cap AS plant_cap,
            plant.city AS plant_city,
            plant.country AS plant_country,
            plant.contract AS plant_contract,
            plant.matriculation AS plant_matriculation,
            plant.code AS plant_code,
            plant.latitude AS plant_latitude,
            plant.longitude AS plant_longitude
            FROM deadlines d
            LEFT JOIN users t ON d.current_technician_id = t.id
            LEFT JOIN plants plant ON d.plant_id = plant.id
            WHERE d.current_technician_id = :technicianId
            order by d.id desc
            LIMIT :limit OFFSET :offset
        ";

        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 

        $statement->bindValue(':technicianId', $technicianId, PDO::PARAM_INT);
        // $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        //$statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                "id" => $row['id'],
                "closed_at" => $row['d_closed_at'],
                "title" => $row['title'],
                "type" => $row['type'],
                "current_technician" => [
                    "id" => $row['technician_id'],
                    "name" => $row['technician_name'],
                    "surname" => $row['technician_surname'],
                    "type" => $row['technician_type'],
                ],
                "date" => $row['d_date'],
                "distance" => 0.70469252783958,
                "model_type" => '',
                "notes" => [
                ],
                "overdue" => true,
                "periodicity" => $row['periodicity'],
                "plant" => [
                    "address" => $row['plant_street'] . " " . $row['plant_number'] . ", " . $row['plant_cap'] . " " . $row['plant_city'] . ", " . $row['plant_city'] . ", " . $row['plant_country'],
                    "cap" => $row['plant_cap'],
                    "city" => $row['plant_city'],
                    "code" => $row['plant_code'],
                    "contract" => $row['plant_contract'],
                    "detail" => "",
                    "id" => $row['plant_id'],
                    "matriculation" => $row['plant_matriculation'],
                    "number" => $row['plant_number'],
                    "street" => $row['plant_street'],
                    "streetview_url" => ""
                ],


            ];
            $plant_latitude = $row['plant_latitude'];
            $plant_longitude = $row['plant_longitude'];


            if ($goObject && $plant_latitude && $plant_longitude) {
                $user_latitude = $goObject['latitude'];
                $user_longitude = $goObject['longitude'];

                $latitudeFrom = $user_latitude;
                $longitudeFrom = $user_longitude;
                $latitudeTo = $plant_latitude;
                $longitudeTo = $plant_longitude;
                $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
                $intervention['distance'] = $distance;
            }
            // Append the intervention to the interventions array
            $interventions[] = $intervention;
        }
        // Convert the array to JSON
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
    }

    public function getPlantsByIdDeadlines($plantId)
    {
        $goObject = $this->currentUserGOPosition;
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 10;
        $offset = ($page - 1) * $rowsPerPage;
        $typology = isset($_GET['typology']) ? $_GET['typology'] : '';
        $sort_by_date = isset($_GET['sort_by_date']) ? $_GET['sort_by_date'] : '';

        // $typeToSearch = '';
        // switch ($params['typology']) {
        //     case 'open':
        //         $typeToSearch = 'Open';
        //         break;
        //     case 'closed':
        //         $typeToSearch = 'Closed';
        //         break;
        // }
        $qSQL = "SELECT count(id) total FROM deadlines WHERE plant_id=:plant_id ";
        if ($typology != "") {
            $qSQL .= " and type like :typology ";
        }
        $stmt = $this->pdo->prepare($qSQL);

        //$stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':plant_id', $plantId);
        if ($typology != "") {
            $stmt->bindValue(':typology', '%' . $typology . '%', PDO::PARAM_STR);
        }
        $stmt->execute();
        $totalData = $stmt->fetch(PDO::FETCH_ASSOC);

        $total = $totalData['total'];

        // Building SQL Query
        $querySQL = "
            SELECT 
            d.*, 
            DATE_FORMAT(d.created_at, '%d/%m/%Y %H:%i:%s') AS d_created_at,
            DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS d_date,
            t.id AS technician_id, 
            t.name AS technician_name, 
            t.surname AS technician_surname, 
            t.type AS technician_type,
            plant.id AS plant_id,
            plant.street AS plant_street,
            plant.number AS plant_number,
            plant.cap AS plant_cap,
            plant.city AS plant_city,
            plant.country AS plant_country,
            plant.contract AS plant_contract,
            plant.matriculation AS plant_matriculation,
            plant.code AS plant_code,
            plant.latitude AS plant_latitude,
            plant.longitude AS plant_longitude
            FROM deadlines d
            LEFT JOIN users t ON d.current_technician_id = t.id
            LEFT JOIN plants plant ON d.plant_id = plant.id
            WHERE plant.id=:plant_id
            
        ";
        if ($typology == "open") {
            $querySQL .= " and d.type like :typology ";
        }


        if ($sort_by_date == "closing") {
            $querySQL .= " order by d.created_at desc ";
        }
        // else {
        //     $querySQL .= " order by d.id desc ";
        // }
        $querySQL .= "  LIMIT :limit OFFSET :offset";

        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 

        $statement->bindValue(':plant_id', $plantId, PDO::PARAM_INT);
        // $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        //  $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        if ($typology == "open") {
            $statement->bindValue(':typology', '%' . $typology . '%', PDO::PARAM_STR);
        }
        //$statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                "id" => $row['id'],
                "closed_at" => $row['d_created_at'],
                "title" => $row['title'],
                "type" => $row['type'],
                "current_technician" => [
                    "id" => $row['technician_id'],
                    "name" => $row['technician_name'],
                    "surname" => $row['technician_surname'],
                    "type" => $row['technician_type'],
                ],
                "date" => $row['d_date'],
                "distance" => null,
                "model_type" => str_contains($row['type'], 'visit') ? "Visit" : "Appointment",
                "notes" => [
                ],
                "overdue" => true,
                "periodicity" => $row['periodicity'],
                "plant" => [
                    "address" => $row['plant_street'] . " " . $row['plant_number'] . ", " . $row['plant_cap'] . " " . $row['plant_city'] . ", " . $row['plant_city'] . ", " . $row['plant_country'],
                    "cap" => $row['plant_cap'],
                    "city" => $row['plant_city'],
                    "code" => $row['plant_code'],
                    "contract" => $row['plant_contract'],
                    "detail" => "",
                    "id" => $row['plant_id'],
                    "matriculation" => $row['plant_matriculation'],
                    "number" => $row['plant_number'],
                    "street" => $row['plant_street'],
                    "streetview_url" => ""
                ],


            ];

            $plant_latitude = $row['plant_latitude'];
            $plant_longitude = $row['plant_longitude'];


            if ($goObject && $plant_latitude && $plant_longitude) {
                $user_latitude = $goObject['latitude'];
                $user_longitude = $goObject['longitude'];

                $latitudeFrom = $user_latitude;
                $longitudeFrom = $user_longitude;
                $latitudeTo = $plant_latitude;
                $longitudeTo = $plant_longitude;
                $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
                $intervention['distance'] = $distance;
            }

            // Append the intervention to the interventions array
            $interventions[] = $intervention;
        }


        // Convert the array to JSON
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        header('access-control-allow-credentials: true');
        header('Access-Control-Expose-Headers: Access-Token, Client, Token-Type, Uid, total, per-page');
        header('Content-Type: application/json');
        header('total: ' . $total);
        header('per-page: ' . $rowsPerPage);
        echo $json;
    }

    public function getDeadlineById($deadLineId)
    {
        $goObject = $this->currentUserGOPosition;
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;
        $typology = isset($_GET['typology']) ? $_GET['typology'] : '';

        // $typeToSearch = '';
        // switch ($params['typology']) {
        //     case 'open':
        //         $typeToSearch = 'Open';
        //         break;
        //     case 'closed':
        //         $typeToSearch = 'Closed';
        //         break;
        // }

        // Building SQL Query
        $querySQL = "
            SELECT 
            d.*, 
            DATE_FORMAT(d.closed_at, '%d/%m/%Y %H:%i:%s') AS deadline_closed_at,
            DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS deadline_date,
            t.id AS technician_id, 
            t.name AS technician_name, 
            t.surname AS technician_surname, 
            t.type AS technician_type,
            plant.id AS plant_id,
            plant.street AS plant_street,
            plant.number AS plant_number,
            plant.cap AS plant_cap,
            plant.city AS plant_city,
            plant.country AS plant_country,
            plant.contract AS plant_contract,
            plant.matriculation AS plant_matriculation,
            plant.code AS plant_code,
            plant.latitude AS plant_latitude,
            plant.longitude AS plant_longitude
            FROM deadlines d
            LEFT JOIN users t ON d.current_technician_id = t.id
            LEFT JOIN plants plant ON d.plant_id = plant.id
            WHERE d.id=:deadline_id
            order by d.id desc
            LIMIT :limit OFFSET :offset
        ";

        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 

        $statement->bindValue(':deadline_id', $deadLineId, PDO::PARAM_INT);
        // $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        //$statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        //$statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        //$interventions = [];
        // foreach ($results as $row) {
        // Prepare the intervention data
        $intervention = [
            "id" => $row['id'],
            "closed_at" => $row['deadline_closed_at'],
            "title" => $row['title'],
            "type" => $row['type'],
            "current_technician" => [
                "id" => $row['technician_id'],
                "name" => $row['technician_name'],
                "surname" => $row['technician_surname'],
                "type" => $row['technician_type'],
            ],
            "date" => $row['deadline_date'],
            "distance" => null,
            "model_type" => '',
            "notes" => [
            ],
            "overdue" => true,
            "periodicity" => $row['periodicity'],
            "plant" => [
                "address" => $row['plant_street'] . " " . $row['plant_number'] . ", " . $row['plant_cap'] . " " . $row['plant_city'] . ", " . $row['plant_city'] . ", " . $row['plant_country'],
                "cap" => $row['plant_cap'],
                "city" => $row['plant_city'],
                "code" => $row['plant_code'],
                "contract" => $row['plant_contract'],
                "detail" => "",
                "id" => $row['plant_id'],
                "matriculation" => $row['plant_matriculation'],
                "number" => $row['plant_number'],
                "street" => $row['plant_street']
            ],


        ];
        $intervention['plant']['streetview_url'] = 'https://maps.googleapis.com/maps/api/streetview?size=506x248&location=' . $intervention['plant']['address'] . '&key=' . $this->GOOGLE_MAPS_API_KEY;
        $plant_latitude = $row['plant_latitude'];
        $plant_longitude = $row['plant_longitude'];


        if ($goObject && $plant_latitude && $plant_longitude) {
            $user_latitude = $goObject['latitude'];
            $user_longitude = $goObject['longitude'];

            $latitudeFrom = $user_latitude;
            $longitudeFrom = $user_longitude;
            $latitudeTo = $plant_latitude;
            $longitudeTo = $plant_longitude;
            $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
            $intervention['distance'] = $distance;
        }

        // Append the intervention to the interventions array
        // $interventions[] = $intervention;
        //}
        // Convert the array to JSON
        $json = json_encode($intervention, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
    }

    public function getDeadlinesByPlantId($PlantId, $deadlineType)
    {
        $goObject = $this->currentUserGOPosition;
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;
        $typology = isset($_GET['typology']) ? $_GET['typology'] : '';
        $model_type = $deadlineType == 'visits' ? 'Visit' : 'Appointment';
        // $typeToSearch = '';
        // switch ($params['typology']) {
        //     case 'open':
        //         $typeToSearch = 'Open';
        //         break;
        //     case 'closed':
        //         $typeToSearch = 'Closed';
        //         break;
        // }

        // Building SQL Query
        $querySQL = "
            SELECT 
            d.*, 
            DATE_FORMAT(d.closed_at, '%d/%m/%Y %H:%i:%s') AS deadline_closed_at,
            DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS deadline_date,
            t.id AS technician_id, 
            t.name AS technician_name, 
            t.surname AS technician_surname, 
            t.type AS technician_type,
            plant.id AS plant_id,
            plant.street AS plant_street,
            plant.number AS plant_number,
            plant.cap AS plant_cap,
            plant.city AS plant_city,
            plant.country AS plant_country,
            plant.contract AS plant_contract,
            plant.matriculation AS plant_matriculation,
            plant.code AS plant_code,
            plant.latitude AS plant_latitude,
            plant.longitude AS plant_longitude
            FROM deadlines d
            LEFT JOIN users t ON d.current_technician_id = t.id
            LEFT JOIN plants plant ON d.plant_id = plant.id
            WHERE plant.id=:plant_id and d.type like :typology and d.type like :model_type
            order by d.id desc
            LIMIT :limit OFFSET :offset
        ";

        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 

        $statement->bindValue(':plant_id', $PlantId, PDO::PARAM_INT);
        // $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        //$statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':model_type', '%' . $model_type . '%', PDO::PARAM_STR);
        $statement->bindValue(':typology', '%' . $typology . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                "id" => $row['id'],
                "closed_at" => $row['deadline_closed_at'],
                "title" => $row['title'],
                "type" => $row['type'],
                "current_technician" => [
                    "id" => $row['technician_id'],
                    "name" => $row['technician_name'],
                    "surname" => $row['technician_surname'],
                    "type" => $row['technician_type'],
                ],
                "date" => $row['deadline_date'],
                "distance" => null,
                "model_type" => $model_type,
                "notes" => [
                ],
                "overdue" => true,
                "periodicity" => $row['periodicity'],
                "plant" => [
                    "address" => $row['plant_street'] . " " . $row['plant_number'] . ", " . $row['plant_cap'] . " " . $row['plant_city'] . ", " . $row['plant_city'] . ", " . $row['plant_country'],
                    "cap" => $row['plant_cap'],
                    "city" => $row['plant_city'],
                    "code" => $row['plant_code'],
                    "contract" => $row['plant_contract'],
                    "detail" => "",
                    "id" => $row['plant_id'],
                    "matriculation" => $row['plant_matriculation'],
                    "number" => $row['plant_number'],
                    "street" => $row['plant_street']
                ],


            ];
            $intervention['plant']['streetview_url'] = 'https://maps.googleapis.com/maps/api/streetview?size=506x248&location=' . $intervention['plant']['address'] . '&key=' . $this->GOOGLE_MAPS_API_KEY;
            $plant_latitude = $row['plant_latitude'];
            $plant_longitude = $row['plant_longitude'];


            if ($goObject && $plant_latitude && $plant_longitude) {
                $user_latitude = $goObject['latitude'];
                $user_longitude = $goObject['longitude'];

                $latitudeFrom = $user_latitude;
                $longitudeFrom = $user_longitude;
                $latitudeTo = $plant_latitude;
                $longitudeTo = $plant_longitude;
                $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
                $intervention['distance'] = $distance;
            }

            // Append the intervention to the interventions array
            $interventions[] = $intervention;
            //}
            // Convert the array to JSON

        }
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
    }

}
