<?php
require_once __DIR__ . '/../helpers/response.php';
require_once __DIR__ . '/BaseController.php';

class WaitingInterventionsController extends BaseController
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 50;
        $offset = ($page - 1) * $rowsPerPage;

        // //$companyId = $this->currentApiUser()['company_id'];

        // if (!isset($_GET['page'])) {
        //     $query = "
        //         SELECT i.*, 
        //                issue.*, 
        //                plant.*, 
        //                tech.*, 
        //                supp_tech.*, 
        //                evt.*, 
        //                notes.*, 
        //                comp.*
        //         FROM interventions i
        //         LEFT JOIN issues issue ON i.issue_id = issue.id
        //         LEFT JOIN plants plant ON i.plant_id = plant.id
        //         LEFT JOIN users tech ON i.current_technician_id = tech.id
        //         LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
        //         LEFT JOIN intervention_events evt ON i.id = evt.intervention_id
        //         LEFT JOIN notes ON i.id = notes.intervention_id
        //         LEFT JOIN companies comp ON i.company_id = comp.id
        //         WHERE i.is_usable = true";
        //     $statement = $this->pdo->prepare($query, []);
        //     $statement->execute();
        //     $interventions = $statement->fetchAll(PDO::FETCH_ASSOC);
        //     //$interventions = $this->pdo->fetchAll($query, []);

        //     http_response_code(200);
        //     echo json_encode($interventions);
        //     return;
        // }

        // if (isset($_GET['query']) && !empty($_GET['query'])) {
        //     $query = $_GET['query'];

        //     $sql1 = "
        //         SELECT i.*, 
        //                issue.*, 
        //                plant.*, 
        //                tech.*, 
        //                supp_tech.*, 
        //                evt.*, 
        //                notes.*, 
        //                comp.*
        //         FROM interventions i
        //         LEFT JOIN issues issue ON i.issue_id = issue.id
        //         LEFT JOIN plants plant ON i.plant_id = plant.id
        //         LEFT JOIN users tech ON i.current_technician_id = tech.id
        //         LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
        //         LEFT JOIN intervention_events evt ON i.id = evt.intervention_id
        //         LEFT JOIN notes ON i.id = notes.intervention_id
        //         LEFT JOIN companies comp ON i.company_id = comp.id
        //         WHERE i.is_usable = true AND plant.street LIKE ?";
        //     $statement = $this->pdo->prepare($sql1, ["%$query%"]);
        //     $statement->execute();
        //     $interventionsOne = $statement->fetchAll(PDO::FETCH_ASSOC);
        //     //$interventionsOne = $this->pdo->fetchAll($sql1, ["%$query%"]);

        //     $sql2 = "
        //         SELECT i.*, 
        //                issue.*, 
        //                plant.*, 
        //                tech.*, 
        //                supp_tech.*, 
        //                evt.*, 
        //                notes.*, 
        //                comp.*
        //         FROM interventions i
        //         LEFT JOIN issues issue ON i.issue_id = issue.id
        //         LEFT JOIN plants plant ON i.plant_id = plant.id
        //         LEFT JOIN users tech ON i.current_technician_id = tech.id
        //         LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
        //         LEFT JOIN intervention_events evt ON i.id = evt.intervention_id
        //         LEFT JOIN notes ON i.id = notes.intervention_id
        //         LEFT JOIN companies comp ON i.company_id = comp.id
        //         WHERE i.is_usable = true AND CONCAT(TRIM(plant.street), ' ', TRIM(plant.number)) LIKE ? AND plant.street NOT LIKE ?";
        //     $statement = $this->pdo->prepare($sql2, ["%$query%", "%$query%"]);
        //     $statement->execute();
        //     $interventionsTwo = $statement->fetchAll(PDO::FETCH_ASSOC);
        //     //$interventionsTwo = $this->pdo->fetchAll($sql2, ["%$query%", "%$query%"]);

        //     $interventions = array_merge($interventionsOne, $interventionsTwo);

        //     // Assuming you have a pagination function
        //     paginate($interventions);
        //     http_response_code(200);
        //     echo json_encode($interventions);
        //     return;
        // }

        $querySQL = "
            SELECT i.id AS intervention_id,
        i.admin_comment,
        i.urgent,
        i.viewed_by_technician,
        i.viewed_by_support_technician,
        i.viewed_by_admin,
        issue.id AS issue_id,
        issue.name AS issue_name,
        issue.position AS issue_position,
            plant.id AS plant_id,
        plant.street AS plant_street,
        plant.number AS plant_number,
        plant.cap AS plant_cap,
        plant.city AS plant_city,
        plant.contract AS plant_contract,
        plant.matriculation AS plant_matriculation,
        plant.code AS plant_code,
        plant.latitude AS plant_latitude,
        plant.longitude AS plant_longitude,
        tech.id AS technician_id,
        tech.name AS technician_name,
        tech.surname AS technician_surname,
        supp_tech.id AS support_technician_id,
        supp_tech.name AS support_technician_name,
        supp_tech.surname AS support_technician_surname,
        comp.id AS company_id,
        comp.name AS company_name,
        comp.phone AS company_phone,
        comp.logo AS company_logo,
        comp.street AS company_street,
        comp.number AS company_number,
        comp.city AS company_city,
        comp.cap AS company_cap,
        comp.province AS company_province,
        comp.country AS company_country
            FROM interventions i
            LEFT JOIN issues issue ON i.issue_id = issue.id
            LEFT JOIN plants plant ON i.plant_id = plant.id
            LEFT JOIN users tech ON i.current_technician_id = tech.id
            LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
            LEFT JOIN notes ON i.id = notes.intervention_id
            LEFT JOIN companies comp ON i.company_id = comp.id
            WHERE i.is_usable = true and i.company_id=:company_id and i.type='WaitingIntervention' 
            AND (plant.street LIKE :searchQuery OR plant.number LIKE :searchQuery)
            Order by i.id desc
            LIMIT :limit OFFSET :offset";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':searchQuery', '%' . $searchQuery . '%');
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                'id' => $row['intervention_id'],
                'admin_comment' => $row['admin_comment'],
                'urgent' => $row['urgent'] == 1,
                'viewed_by_technician' => $row['viewed_by_technician'] == 1,
                'viewed_by_support_technician' => $row['viewed_by_support_technician'] == 1,
                'viewed_by_admin' => $row['viewed_by_admin'] == 1,
                'notes' => [], // Assuming notes are fetched elsewhere
                'technician_distance_from_plant' => null, // Set this if you have the data
                'issue' => [
                    'id' => $row['issue_id'],
                    'name' => $row['issue_name'],
                    'position' => $row['issue_position']
                ],
                'plant' => [
                    'id' => $row['plant_id'],
                    'address' => '',
                    'street' => $row['plant_street'],
                    'number' => $row['plant_number'],
                    'cap' => $row['plant_cap'],
                    'city' => $row['plant_city'],
                    'detail' => '',
                    'contract' => $row['plant_contract'],
                    'matriculation' => $row['plant_matriculation'],
                    'code' => $row['plant_code'],
                    'streetview_url' => ''
                ],
                'current_technician' => [
                    'id' => $row['technician_id'],
                    'name' => $row['technician_name'],
                    'surname' => $row['technician_surname'],
                    'type' => 'technician'
                ],
                'current_support_technician' => $row['support_technician_id'] ? [
                    'id' => $row['support_technician_id'],
                    'name' => $row['support_technician_name'],
                    'surname' => $row['support_technician_surname'],
                    'type' => 'support_technician'
                ] : null,

                'type' => 'OpenIntervention', // Adjust this as needed
                'report' => null, // Set this if you have the data
                'report_digital_signature' => null, // Set this if you have the data
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'phone' => $row['company_phone']
                ]
            ];

            $intervention_id = $row['intervention_id'];
            $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS note_created_at FROM notes WHERE intervention_id = :intervention_id");
            $stmt->bindParam(':intervention_id', $intervention_id);
            $stmt->execute();
            $notesData = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($notesData as $noterow) {
                $note = [
                    'id' => $noterow['id'],
                    'title' => $noterow['title'],
                    'text' => $noterow['text'],
                    'viewed_by_admin' => $noterow['viewed_by_admin'],
                    'technician_id' => $noterow['technician_id'],
                    'created_at' => $noterow['note_created_at'],
                    'photos' => [] // Initialize the photos array
                ];


                $note_id = $noterow['id'];
                $stmt = $this->pdo->prepare("SELECT * FROM photos WHERE note_id = :note_id");
                $stmt->bindParam(':note_id', $note_id);
                $stmt->execute();
                $photosData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                foreach ($photosData as $photorow) {
                    $note['photos'][] = [
                        'id' => $photorow['id'],
                        'url' => $this->SITE_URL . '/uploads/photo/data/' . $photorow['id'] . '/' . $photorow['data']
                    ];
                }
                $intervention['notes'][] = $note;

            }

            $intervention_id = $row['intervention_id'];
            $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id");
            $stmt->bindParam(':intervention_id', $intervention_id);
            $stmt->execute();
            $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($eventsData as $eventrow) {
                $intervention['intervention_events'][] = [
                    'id' => $eventrow['id'],
                    'intervention_id' => $eventrow['intervention_id'],
                    'technician_id' => $eventrow['technician_id'],
                    'admin_id' => $eventrow['admin_id'],
                    'type' => $eventrow['type'],
                    'created_at' => $eventrow['event_created_at'],
                ];
            }

            // Append the intervention to the interventions array
            $interventions[] = $intervention;
        }

        // Convert the array to JSON
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;

    }
}
