<?php
require_once __DIR__ . '/../helpers/response.php';
// require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';
class VisitsController extends BaseController
{
    //private $pdo;

    public function __construct()
    {
        parent::__construct();
        // $this->pdo = require __DIR__ . '/../config/database.php';
    }

    public function index()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $rowsPerPage = 1000;
        $offset = ($page - 1) * $rowsPerPage;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $from = isset($_GET['from']) ? $_GET['from'] : '';
        $to = isset($_GET['to']) ? $_GET['to'] : '';
        $model = isset($_GET['model']) && $_GET['model'] === 'appointments' ? 'Appointment' : 'Visit';

        $querySQL = "
                SELECT 
                d.*,
                DATE_FORMAT(d.date, '%d/%m/%Y %H:%i:%s') AS deadline_date,
                p.name,
                p.street,
                p.number,
                p.city,
                p.cap,
                p.province,
                p.country,
                p.latitude,
                p.longitude,
                p.typology,
                p.telephone,
                p.code,
                p.contract,
                p.matriculation,
                t.id AS technician_id,
                t.name AS technician_name,
                t.surname AS technician_surname,
                t.type AS technician_type
                FROM deadlines d
                LEFT JOIN plants p ON p.id=d.plant_id
                LEFT JOIN users t ON d.current_technician_id = t.id
                WHERE d.company_id = :company_id
                and d.type like :type
                and d.date between :from and :to
                order by d.id desc
                
            ";
        // LIMIT :limit OFFSET :offset
        $statement = $this->pdo->prepare($querySQL);


        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':type', '%' . $model . '%', PDO::PARAM_STR);
        // $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':from', $from, PDO::PARAM_STR);
        $statement->bindValue(':to', $to, PDO::PARAM_STR);
        //$statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        // $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        // $statement->debugDumpParams();
        // die;
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $plants = [];
        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'periodicity' => $row['periodicity'],
                'date' => $row['deadline_date'],
                'plant' => [
                    'id' => $row['plant_id'],
                    'address' => $row['street'] . " " . $row['number'] . ", " . $row['cap'] . " " . $row['city'] . ", " . $row['city'] . ", " . $row['country'],
                    'street' => $row['street'],
                    'number' => $row['number'],
                    'cap' => $row['cap'],
                    'city' => $row['city'],
                    'contract' => $row['contract'],
                    'matriculation' => $row['matriculation'],
                    'code' => $row['code'],
                    //'detail' => $row['detail'],
                    'latitude' => $row['latitude'],
                    'longitude' => $row['longitude'],
                    'streetview_url' => ''
                ],
                'current_technician' => [
                    'id' => $row['technician_id'],
                    'name' => $row['technician_name'],
                    'surname' => $row['technician_surname'],
                    'type' => $row['technician_type']
                ],
                'type' => $row['type'],
                'notes' => [],
                'overdue' => true,
                'closed_at' => $row['closed_at'],
                'model_type' => $model
            ];
            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;
    }


    // public function create()
    // {
    //     $typology = $_POST['typology'];

    //     if ($typology != "MaintenanceVisit" && $typology != "SemiannualVisit") {
    //         $this->renderJson(['error' => ["Il campo typology ammette i valori 'MaintenanceVisit' e 'SemiannualVisit'."]], 422);
    //         return;
    //     }

    //     $visit_params = $this->visitParams();
    //     $visit = new Visit($visit_params);
    //     $visit->company_id = $this->current_user->company_id;
    //     $visit->current_technician_id = Plant::find($visit_params['plant_id'])->maintainer_id;

    //     switch ($typology) {
    //         case "MaintenanceVisit":
    //             $visit->type = "OpenMaintenanceVisit";
    //             break;
    //         case "SemiannualVisit":
    //             $visit->type = "OpenSemiannualVisit";
    //             $visit->periodicity = "semiannual";
    //             break;
    //     }

    //     if ($visit->save()) {
    //         $this->renderJson($visit, 201);
    //     } else {
    //         $this->renderJson(['errors' => $visit->errors], 422);
    //     }
    // }

    // public function show($id)
    // {
    //     $visit = Visit::find($id);

    //     if ($visit->company_id != $this->current_user->company_id) {
    //         $this->renderJson(['errors' => ["Non puoi accedere alle visite di altre compagnie."]], 403);
    //         return;
    //     }

    //     $this->renderJson($visit, 200);
    // }


    // public function update($id)
    // {
    //     $visit = Visit::find($id);

    //     if ($visit->company_id != $this->current_user->company_id) {
    //         $this->renderJson(['errors' => ["Non puoi aggiornare le visite di altre compagnie."]], 403);
    //         return;
    //     }

    //     if ($_POST['operation'] == "close") {
    //         if ($visit->close($this->current_user)) {
    //             $this->renderJson($visit, 202);
    //         } else {
    //             $this->renderJson(['errors' => $visit->errors], 422);
    //         }
    //         return;
    //     }

    //     $this->renderJson(['errors' => ["Invalid parameters passed to VisitsController#update"]], 400);
    // }

    // public function destroy($id)
    // {
    //     $visit = Visit::find($id);

    //     if ($visit->company_id != $this->current_user->company_id) {
    //         $this->renderJson(['errors' => ["Non puoi eliminare le visite di altre compagnie"]], 403);
    //         return;
    //     }

    //     if ($visit && $visit->delete()) {
    //         http_response_code(204);
    //     } else {
    //         $this->renderJson(['errors' => $visit->errors], 406);
    //     }
    // }

    // private function visitParams()
    // {
    //     return [
    //         'id' => $_POST['id'],
    //         'company_id' => $_POST['company_id'],
    //         'periodicity' => $_POST['periodicity'],
    //         'date' => $_POST['date'],
    //         'plant_id' => $_POST['plant_id']
    //     ];
    // }

    // private function renderJson($data, $status)
    // {
    //     http_response_code($status);
    //     header('Content-Type: application/json');
    //     echo json_encode($data);
    //     exit();
    // }

    // private function paginate($query)
    // {
    //     // Implement your pagination logic here
    //     return $query;
    // }
}
