<?php
require_once __DIR__ . '/../helpers/response.php';
// require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';
class UsersController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
        // $this->pdo = require __DIR__ . '/../config/database.php';
    }

    // Returns the complete list of users.
    // If 'allow_inactive=true' param is included, then unusable users will be included too.
    public function getUserById($id)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM users
        WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $userData = $stmt->fetch(PDO::FETCH_ASSOC);
        $company_id = $userData['company_id'];
        $stmt = $this->pdo->prepare("SELECT * FROM companies WHERE id = :id");
        $stmt->bindParam(':id', $company_id);
        $stmt->execute();
        $comData = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($comData != null) {
            $comData['address'] = [
                'street' => $comData['street'],
                'number' => $comData['number'],
                'city' => $comData['city'],
                'cap' => $comData['cap'],
                'province' => $comData['province'],
                'country' => $comData['country']
            ];
            $userData['company'] = $comData;
        }
        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id");
        $stmt->bindParam(':technician_id', $user_id);
        $stmt->execute();
        $posData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['position'] = $posData;

        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM technician_levels WHERE company_id = :company_id");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->execute();
        $techData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['technician_level'] = $techData;
        $userData['distance_from_plant'] = null;
        $userData['open_interventions_count'] = 0;
        $userData['closed_interventions_count'] = 0;
        $jsonOutput = json_encode($userData);

        header('Content-Type: application/json');
        echo $jsonOutput;
    }
    // public function getUserByCable()
    // {
    //     $uid = isset($_GET['uid']) ? $_GET['uid'] : '';
    //     $access_token = isset($_GET['access-token']) ? $_GET['access-token'] : '';
    //     $client = isset($_GET['client']) ? $_GET['client'] : '';
    //     $stmt = $this->pdo->prepare("SELECT * FROM users
    //     WHERE uid = :uid");
    //     $stmt->bindParam(':uid', $uid);
    //     $stmt->execute();
    //     $userData = $stmt->fetch(PDO::FETCH_ASSOC);
    //     $company_id = $userData['company_id'];
    //     $stmt = $this->pdo->prepare("SELECT * FROM companies WHERE id = :id");
    //     $stmt->bindParam(':id', $company_id);
    //     $stmt->execute();
    //     $comData = $stmt->fetch(PDO::FETCH_ASSOC);
    //     if ($comData != null) {
    //         $comData['address'] = [
    //             'street' => $comData['street'],
    //             'number' => $comData['number'],
    //             'city' => $comData['city'],
    //             'cap' => $comData['cap'],
    //             'province' => $comData['province'],
    //             'country' => $comData['country']
    //         ];
    //         $userData['company'] = $comData;
    //     }
    //     $user_id = $userData['id'];
    //     $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id");
    //     $stmt->bindParam(':technician_id', $user_id);
    //     $stmt->execute();
    //     $posData = $stmt->fetch(PDO::FETCH_ASSOC);
    //     $userData['position'] = $posData;

    //     $user_id = $userData['id'];
    //     $stmt = $this->pdo->prepare("SELECT * FROM technician_levels WHERE company_id = :company_id");
    //     $stmt->bindParam(':company_id', $company_id);
    //     $stmt->execute();
    //     $techData = $stmt->fetch(PDO::FETCH_ASSOC);
    //     $userData['technician_level'] = $techData;
    //     $userData['distance_from_plant'] = null;
    //     $userData['open_interventions_count'] = 0;
    //     $userData['closed_interventions_count'] = 0;
    //     $jsonOutput = json_encode($userData);

    //     header('Content-Type: application/json');
    //     echo $jsonOutput;
    // }
    // public function index($params)
    // {
    //     //     $stmt = $this->pdo->prepare("SELECT * FROM users
    //     //     WHERE email = :email");
    //     //    $stmt->bindParam(':email', $email);
    //     //    $stmt->execute();
    //     //    $current_api_user = $stmt->fetch(PDO::FETCH_ASSOC);

    //     if (isset($params['allow_inactive']) && $params['allow_inactive'] === 'true') {
    //         $query = "SELECT * FROM users WHERE company_id = :company_id";
    //     } else {
    //         $query = "SELECT * FROM users WHERE is_usable = true AND company_id = :company_id";
    //     }

    //     $statement = $this->pdo->prepare($query);
    //     $statement->execute(['company_id' => $this->current_api_user['company_id']]);
    //     $users = $statement->fetchAll(PDO::FETCH_ASSOC);

    //     http_response_code(201);
    //     echo json_encode($users);
    // }
    // // Creates a new user.
    // public function create($params)
    // {
    //     $query = "INSERT INTO users (email, password, name, surname, phone, company_id) 
    //               VALUES (:email, :password, :name, :surname, :phone, :company_id)";

    //     $statement = $this->pdo->prepare($query);
    //     $result = $statement->execute([
    //         'email' => $params['email'],
    //         'password' => password_hash($params['password'], PASSWORD_BCRYPT),
    //         'name' => $params['name'],
    //         'surname' => $params['surname'],
    //         'phone' => $params['phone'],
    //         'company_id' => $this->current_api_user['company_id']
    //     ]);

    //     if ($result) {
    //         http_response_code(201);
    //         echo json_encode(['id' => $this->pdo->lastInsertId()]);
    //     } else {
    //         http_response_code(422);
    //         echo json_encode(['errors' => $statement->errorInfo()]);
    //     }
    // }

    // // Returns a user
    // public function show($params)
    // {
    //     $query = "SELECT * FROM users WHERE id = :id";
    //     $statement = $this->pdo->prepare($query);
    //     $statement->execute(['id' => $params['id']]);
    //     $user = $statement->fetch(PDO::FETCH_ASSOC);

    //     if (!$user || $user['company_id'] !== $this->current_api_user['company_id']) {
    //         http_response_code(403);
    //         echo json_encode(['errors' => ["Non puoi accedere agli utenti di altre compagnie."]]);
    //         return;
    //     }

    //     if ($user['is_usable']) {
    //         echo json_encode($user);
    //     } else {
    //         http_response_code(401);
    //         echo json_encode(['errors' => ["Questo account non è più utilizzabile per effettuare l'accesso a Vuala'"]]);
    //     }
    // }

    // // Updates a user. This method could be used to reactivate a user, too.
    // public function update($params)
    // {
    //     $query = "SELECT * FROM users WHERE id = :id AND is_usable = true";
    //     $statement = $this->pdo->prepare($query);
    //     $statement->execute(['id' => $params['id']]);
    //     $user = $statement->fetch(PDO::FETCH_ASSOC);

    //     if (!$user || $user['company_id'] !== $this->current_api_user['company_id']) {
    //         http_response_code(403);
    //         echo json_encode(['errors' => ["Non puoi aggiornare un utente di un'altra compagnia."]]);
    //         return;
    //     }

    //     $query = "UPDATE users SET name = :name, email = :email, surname = :surname, phone = :phone WHERE id = :id";
    //     $statement = $this->pdo->prepare($query);
    //     $result = $statement->execute([
    //         'id' => $params['id'],
    //         'name' => $params['name'],
    //         'email' => $params['email'],
    //         'surname' => $params['surname'],
    //         'phone' => $params['phone']
    //     ]);

    //     if ($result) {
    //         http_response_code(201);
    //         echo json_encode($user);
    //     } else {
    //         http_response_code(422);
    //         echo json_encode(['errors' => $statement->errorInfo()]);
    //     }
    // }

    // // Makes a user no more usable.
    // public function destroy($params)
    // {
    //     $query = "SELECT * FROM users WHERE id = :id AND is_usable = true";
    //     $statement = $this->pdo->prepare($query);
    //     $statement->execute(['id' => $params['id']]);
    //     $user = $statement->fetch(PDO::FETCH_ASSOC);

    //     if (!$user || ($user['company_id'] !== $this->current_api_user['company_id'] && !$this->current_api_user['superadmin'])) {
    //         http_response_code(403);
    //         echo json_encode(['errors' => ["Non puoi ibernare un utente di un'altra compagnia"]]);
    //         return;
    //     }

    //     $query = "UPDATE users SET is_usable = false WHERE id = :id";
    //     $statement = $this->pdo->prepare($query);
    //     $result = $statement->execute(['id' => $params['id']]);

    //     if ($result) {
    //         http_response_code(204);
    //     } else {
    //         http_response_code(422);
    //         echo json_encode(['errors' => $statement->errorInfo()]);
    //     }
    // }

    // private function user_params($params)
    // {
    //     return [
    //         'name' => $params['name'],
    //         'email' => $params['email'],
    //         'surname' => $params['surname'],
    //         'phone' => $params['phone'],
    //         'password' => $params['password'],
    //         'password_confirmation' => $params['password_confirmation'],
    //         'one_signal_id' => $params['one_signal_id'],
    //         'user_class' => $params['user_class']
    //     ];
    // }
}
