<?php

require_once __DIR__ . '/../helpers/response.php';
//require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';

require '../PHPMailer/src/Exception.php';
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
class TechniciansController extends BaseController
{
    //private $pdo;

    public function __construct()
    {
        parent::__construct();
        // $this->pdo = require __DIR__ . '/../config/database.php';
    }

    // Returns the list of usable technicians belonging to current user's company.
    // If 'allow_inactive=true' parameter is supplied, then also unusable technicians get included.
    public function index()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        // $allow_inactive = isset($_GET['allow_inactive']) ? true : false;
        $maintainer_id = isset($_GET['maintainer_id']) ? $_GET['maintainer_id'] : null;
        $plant_id = isset($_GET['plant_id']) ? $_GET['plant_id'] : null;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $rowsPerPage = 50;
        $offset = ($page - 1) * $rowsPerPage;

        // if ($allow_inactive) {
        //     $sql = "SELECT * FROM users WHERE type='Technician' AND company_id = :company_id";
        // } else {
        $sql = "SELECT 
            u.id,
        u.name,
        u.nickname,
        u.email,
        u.surname,
        u.phone,
        u.birthdate,
        u.role,
        u.speciality,
        u.current_state,
        u.type,
        t.id AS level_id,
        t.name AS level_name,
         comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
        FROM users u
         LEFT JOIN companies comp ON u.company_id = comp.id
        LEFT JOIN technician_levels t on t.id = u.technician_level_id
        AND (u.name LIKE :searchQuery OR u.nickname LIKE :searchQuery OR u.email LIKE :searchQuery OR u.surname LIKE :searchQuery OR u.phone LIKE :searchQuery)
        -- LEFT JOIN plants p on p.maintainer_id=u.id
        WHERE type='Technician' AND u.is_usable = true AND u.company_id = :company_id";
        // }

        if ($maintainer_id) {
            $sql .= " AND u.id != :maintainer_id";
        }
        // if ($plant_id) {
        //     $sql .= " AND p.id != :plant_id";
        // }
        $sql .= "  order by u.surname, u.name ";
        $sql .= "  LIMIT :limit OFFSET :offset";

        $statement = $this->pdo->prepare($sql);
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        if ($maintainer_id) {
            $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_INT);
        }
        // if ($plant_id) {
        //     $statement->bindValue(':plant_id', $plant_id, PDO::PARAM_INT);
        // }
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $plants = [];
        foreach ($results as $row) {

            $technician_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT count(id) as id_count FROM interventions WHERE  company_id = :company_id and type='OpenIntervention' and current_technician_id = :current_technician_id order by closed_at desc");
            $stmt->bindParam(':company_id', $company_id);
            $stmt->bindParam(':current_technician_id', $technician_id);
            $stmt->execute();
            $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
            $id_count = $plantsData['id_count'];

            $stmt = $this->pdo->prepare("SELECT count(id) as id_count FROM interventions WHERE  company_id = :company_id and type='ClosedIntervention' and current_technician_id = :current_technician_id and plant_id=:plant_id order by closed_at desc");
            $stmt->bindParam(':company_id', $company_id);
            $stmt->bindParam(':current_technician_id', $technician_id);
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $plantsDataw = $stmt->fetch(PDO::FETCH_ASSOC);
            $closed_count = $plantsDataw['id_count'];

            $technician_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id order by created_at desc limit 1");
            $stmt->bindParam(':technician_id', $technician_id);
            $stmt->execute();
            $tecData = $stmt->fetch(PDO::FETCH_ASSOC);


            $plant = [
                'id' => $row['id'],
                'name' => $row['name'],
                'nickname' => $row['nickname'],
                'email' => $row['email'],
                'surname' => $row['surname'],
                'phone' => $row['phone'],
                'birthdate' => $row['birthdate'],
                'role' => $row['role'],
                'speciality' => $row['speciality'],
                'current_state' => $row['current_state'],
                'type' => $row['type'],

                "distance_from_plant" => 0,
                'open_interventions_count' => $id_count,
                'closed_interventions_count' => $closed_count,
                'technician_level' => [
                    'id' => $row['level_id'],
                    'name' => $row['level_name']
                ],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'phone' => $row['company_phone']
                ]
            ];
            $latitude = 0;
            $longitude = 0;
            $created_at = '';
            if ($tecData !== false && $tecData !== null) {

                $latitude = $tecData['latitude'];
                $longitude = $tecData['longitude'];
                $created_at = $tecData['created_at'];

            }
            $plant['position'] = [
                'latitude' => $latitude,
                'longitude' => $longitude,
                'created_at' => $created_at
            ];

            $stmt = $this->pdo->prepare("SELECT * FROM plants WHERE id = :plant_id");
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $plantObj = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($plantObj != null && $tecData !== null) {
                $latitudeFrom = $latitude;
                $longitudeFrom = $longitude;
                $latitudeTo = $plantObj['latitude'];
                $longitudeTo = $plantObj['longitude'];
                $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
                $plant['distance_from_plant'] = $distance;
            }

            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;

        // if ($plant_id) {
        //     $plant = $this->findPlantById($plant_id);
        //     foreach ($technicians as &$technician) {
        //         $last_position = $this->getLastPosition($technician['id']);
        //         if ($last_position) {
        //             $technician['distance_from_plant'] = $this->calculateDistance($last_position, $plant);
        //         }
        //     }
        //     usort($technicians, function ($tec1, $tec2) {
        //         if (isset($tec1['distance_from_plant']) && isset($tec2['distance_from_plant'])) {
        //             return $tec1['distance_from_plant'] <=> $tec2['distance_from_plant'];
        //         } elseif (isset($tec1['distance_from_plant'])) {
        //             return -1;
        //         } else {
        //             return 1;
        //         }
        //     });
        // }

        // header('Content-Type: application/json');
        // echo json_encode($technicians);
        // return;
    }



    public function getTechnicianById($tech_id)
    {
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        $allow_inactive = isset($_GET['allow_inactive']) ? true : false;
        $maintainer_id = isset($_GET['maintainer_id']) ? $_GET['maintainer_id'] : null;
        $plant_id = isset($_GET['plant_id']) ? $_GET['plant_id'] : null;
        $query = isset($_GET['query']) ? $_GET['query'] : '';

        $sql = "SELECT 
            u.id,
        u.name,
        u.nickname,
        u.email,
        u.surname,
        u.phone,
        u.birthdate,
        u.role,
        u.speciality,
        u.current_state,
        u.type,
        t.id AS level_id,
        t.name AS level_name,
         comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
        FROM users u
         LEFT JOIN companies comp ON u.company_id = comp.id
        LEFT JOIN technician_levels t on t.id = u.technician_level_id
         LEFT JOIN plants p on p.maintainer_id=u.id
        WHERE type='Technician' AND u.is_usable = true
        and u.id=:tech_id
        ";
        // }


        // if ($maintainer_id) {
        //     $sql .= " AND id != :maintainer_id";
        // }


        $statement = $this->pdo->prepare($sql);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->bindValue(':tech_id', $tech_id, PDO::PARAM_INT);
        // if ($maintainer_id) {
        //     $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_INT);
        // }
        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        //$plants = [];
        //foreach ($results as $row) {

        //   $technician_id = $row['id'];
        $stmt = $this->pdo->prepare("SELECT count(id) as id_count FROM interventions WHERE type='OpenIntervention' and current_technician_id = :current_technician_id order by closed_at desc");
        // $stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':current_technician_id', $tech_id);
        $stmt->execute();
        $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
        $open_count = $plantsData['id_count'];

        $stmt = $this->pdo->prepare("SELECT count(id) as id_count FROM interventions WHERE type='ClosedIntervention' and current_technician_id = :current_technician_id and plant_id=:plant_id order by closed_at desc");
        // $stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':current_technician_id', $tech_id);
        $stmt->bindParam(':plant_id', $plant_id);
        $stmt->execute();
        $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
        $closed_count = $plantsData['id_count'];



        $plant = [
            'id' => $row['id'],
            'name' => $row['name'],
            'nickname' => $row['nickname'],
            'email' => $row['email'],
            'surname' => $row['surname'],
            'phone' => $row['phone'],
            'birthdate' => $row['birthdate'],
            'role' => $row['role'],
            'speciality' => $row['speciality'],
            'current_state' => $row['current_state'],
            'type' => $row['type'],
            'distance_from_plant' => 0,
            'open_interventions_count' => $open_count,
            'closed_interventions_count' => $closed_count,
            'technician_level' => [
                'id' => $row['level_id'],
                'name' => $row['level_name']
            ],
            'company' => [
                'id' => $row['company_id'],
                'name' => $row['company_name'],
                'address' => [
                    'street' => $row['company_street'],
                    'number' => $row['company_number'],
                    'city' => $row['company_city'],
                    'cap' => $row['company_cap'],
                    'province' => $row['company_province'],
                    'country' => $row['company_country']
                ],
                'logo' => $row['company_logo'],
                'phone' => $row['company_phone']
            ]
        ];

        //   $technician_id = $row['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id order by created_at desc limit 1");
        $stmt->bindParam(':technician_id', $tech_id);
        $stmt->execute();
        $geoData = $stmt->fetch(PDO::FETCH_ASSOC);
        $latitude = '';
        $longitude = '';
        $created_at = '';
        if ($geoData !== false && $geoData !== null) {

            $latitude = $geoData['latitude'];
            $longitude = $geoData['longitude'];
            $created_at = $geoData['created_at'];

        }
        if ($latitude != "" || $longitude != "") {
            $plant['position'] = [
                'latitude' => $latitude,
                'longitude' => $longitude,
                'created_at' => $created_at
            ];
        }


        $stmt = $this->pdo->prepare("SELECT * FROM plants WHERE id = :plant_id");
        $stmt->bindParam(':plant_id', $plant_id);
        $stmt->execute();
        $plantObj = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($plantObj != null && $geoData !== null) {
            $latitudeFrom = $latitude;
            $longitudeFrom = $longitude;
            $latitudeTo = $plantObj['latitude'];
            $longitudeTo = $plantObj['longitude'];
            $distance = $this->haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo);
            $plant['distance_from_plant'] = $distance;
        }
        //$plants[] = $plant;
        //  }
        $json = json_encode($plant, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;
    }

    // Helper methods
    public function getTechnicianlevels()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $sql = "SELECT 
        t.id, 
        t.name,
        c.id AS company_id,
                c.name AS company_name,
                c.phone AS company_phone,
                c.logo AS company_logo,
                c.street AS company_street,
                c.number AS company_number,
                c.city AS company_city,
                c.cap AS company_cap,
                c.province AS company_province,
                c.country AS company_country,
                c.latitude,
                c.longitude 
        FROM technician_levels t
        inner join companies c on c.id = t.company_id
        WHERE company_id = :company_id";
        $statement = $this->pdo->prepare($sql);
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);
        $plants = [];
        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'name' => $row['name'],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'technicians_count' => 0,
                    'admins_count' => 0,
                    'phone' => $row['company_phone'],
                    'latitude' => $row['latitude'],
                    'longitude' => $row['longitude'],

                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'streetview_url' => '',
                ]
            ];



            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;
    }

    // Creates a new technician
    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $email = isset($postData['email']) ? $postData['email'] : '';
                    $password = isset($postData['password']) ? $postData['password'] : '';
                    $password_confirmation = isset($postData['password_confirmation']) ? $postData['password_confirmation'] : '';
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    $speciality = isset($postData['speciality']) ? $postData['speciality'] : '';
                    $surname = isset($postData['surname']) ? $postData['surname'] : '';
                    $technician_level_id = isset($postData['technician_level_id']) ? (int) $postData['technician_level_id'] : null;

                    if ($password !== $password_confirmation) {
                        echo json_encode(['errors' => ['Password confirmation does not match']]);
                        http_response_code(422);
                        return;
                    }

                    $sql = "INSERT INTO users (name, surname, phone, speciality, technician_level_id, company_id, email,uid, encrypted_password, created_at, updated_at, current_state, type) 
                VALUES (:name, :surname, :phone, :speciality, :technician_level_id, :company_id, :email, :uid, :password, now(), now(), 'free', 'Technician')";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':surname', $surname, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    $statement->bindValue(':speciality', $speciality, PDO::PARAM_STR);
                    $statement->bindValue(':technician_level_id', $technician_level_id, PDO::PARAM_INT);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    $statement->bindValue(':email', $email, PDO::PARAM_STR);
                    $statement->bindValue(':uid', $email, PDO::PARAM_STR);
                    $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    // if ($statement->execute()) {
                    //     // Return a success response
                    //     $response = [
                    //         'status' => 'success',
                    //         'message' => 'Intervention created successfully.'
                    //     ];
                    // } else {
                    //     // Return an error response
                    //     $response = [
                    //         'status' => 'error',
                    //         'message' => 'Failed to create intervention.'
                    //     ];
                    // }
                    // // Return the response as JSON
                    // header('Content-Type: application/json');
                    // echo json_encode($response);
                    if ($statement->execute()) {
                        // Assuming sendWelcomeMail() and sendResetPasswordInstructions() are functions defined elsewhere
                        $technician_id = $this->pdo->lastInsertId();
                        $this->sendMail($email, $password, $name);
                        // $this->sendResetPasswordInstructions($email);

                        $technician = $this->findTechnicianById($technician_id);
                        header('Content-Type: application/json');
                        echo json_encode($technician);
                        // http_response_code(201);
                    } else {
                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                    }
                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }

    function sendMail($email, $password, $name)
    {
        // print_r($_SERVER);
        $scheme = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';

        // Get the host name (e.g., www.vuala.com)
        $host = $_SERVER['HTTP_ORIGIN'];

        // Construct the base URL (e.g., https://www.vuala.com)
        //$loginUrl = $scheme . '://' . $host;

        //echo $loginUrl;
        // Define the subject of the email
        $subject = "Welcome to Vuala";

        // Define the login URL (update the URL as needed)
        // $loginUrl = "https://www.vuala.com/login";

        // Create the HTML message
        $message = "
        <html>
        <head>
            <title>Welcome to Vuala</title>
        </head>
        <body>
            <h2>Welcome to Vuala!</h2>
            <p>Dear user,</p>
            <p>Thank you for registering with Vuala. Below are your login details:</p>
            <table>
                <tr>
                    <td><strong>Username (Email):</strong></td>
                    <td>{$email}</td>
                </tr>
                <tr>
                    <td><strong>Password:</strong></td>
                    <td>{$password}</td>
                </tr>
            </table>
            <p>You can log in to your account by clicking the link below:</p>
            <p><a href='{$host}' target='_blank'>Login to Vuala</a></p>
            <p>If you have any questions, feel free to contact our support team.</p>
            <p>Best regards,</p>
            <p>The Vuala Team</p>
        </body>
        </html>
        ";


        // Create a new PHPMailer instance
        $mail = new PHPMailer(true);

        try {
            // Server settings
            $mail->isSMTP();                                     // Set mailer to use SMTP
            $mail->Host = $this->SMTP_Host;              // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                            // Enable SMTP authentication
            $mail->Username = $this->SMTP_Username;     // SMTP username
            $mail->Password = $this->SMTP_Password;                 // SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;    // Enable TLS encryption, `PHPMailer::ENCRYPTION_SMTPS` also accepted
            $mail->Port = 587;                             // TCP port to connect to

            // Recipients
            $mail->setFrom($this->SMTP_Username, 'Vuala');
            $mail->addAddress($email, $name); // Add a recipient

            // Content
            $mail->isHTML(true);                                // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $message;
            //$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            $mail->send();
            //   echo 'Message has been sent';
        } catch (Exception $e) {
            //  echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }


    }

    public function update($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'PATCH') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $email = isset($postData['email']) ? $postData['email'] : '';

                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    $speciality = isset($postData['speciality']) ? $postData['speciality'] : '';
                    $surname = isset($postData['surname']) ? $postData['surname'] : '';
                    $technician_level_id = isset($postData['technician_level_id']) ? (int) $postData['technician_level_id'] : null;

                    $password = isset($postData['password']) ? $postData['password'] : '';
                    $password_confirmation = isset($postData['password_confirmation']) ? $postData['password_confirmation'] : '';

                    if ($password !== $password_confirmation) {
                        echo json_encode(['errors' => ['Password confirmation does not match']]);
                        http_response_code(422);
                        return;
                    }

                    $sql = "UPDATE users set name=:name, surname=:surname, phone=:phone, speciality=:speciality, technician_level_id=:technician_level_id, email=:email,uid=:uid, ";

                    if ($password !== "") {
                        $sql .= " encrypted_password=:password, ";
                    }
                    $sql .= " updated_at=now() WHERE id = :id ";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':surname', $surname, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    $statement->bindValue(':speciality', $speciality, PDO::PARAM_STR);
                    $statement->bindValue(':technician_level_id', $technician_level_id, PDO::PARAM_INT);
                    //$statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    $statement->bindValue(':email', $email, PDO::PARAM_STR);
                    $statement->bindValue(':uid', $email, PDO::PARAM_STR);
                    $statement->bindValue(':id', $id, PDO::PARAM_INT);
                    if ($password !== "") {
                        $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    }
                    // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    if ($statement->execute()) {
                        // Return a success response
                        $technician = $this->findTechnicianById($id);
                        header('Content-Type: application/json');
                        echo json_encode($technician);
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create intervention.'
                        ];
                    }

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be PATCH'
            ]);
        }

    }

    public function distroy($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $companyObject = $this->currentUserCompany;
            $company_id = $companyObject['id'];

            //$sql = "UPDATE users SET is_usable = false, tokens = '{}' WHERE id = :id";
            $sql = "DELETE FROM users WHERE id = :id";

            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Techinician deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create intervention.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }

    public function createLevel()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $name = isset($postData['name']) ? $postData['name'] : '';


                    $sql = "INSERT INTO technician_levels (name, company_id, created_at, updated_at) 
                VALUES (:name, :company_id, now(), now())";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);

                    if ($statement->execute()) {
                        // Return a success response
                        $response = [
                            'status' => 'success',
                            'message' => 'Created successfully.'
                        ];
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create.'
                        ];
                    }
                    // Return the response as JSON
                    header('Content-Type: application/json');
                    echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }

    public function distroyLevel($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $companyObject = $this->currentUserCompany;
            $company_id = $companyObject['id'];

            // $sql = "UPDATE technician_levels SET is_usable = false WHERE id = :id";
            $sql = "DELETE FROM technician_levels WHERE id = :id";
            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }

    // // Returns a technician
    // public function show($id)
    // {
    //     $company_id = $_GET['company_id']; // Replace this with actual user session or auth data
    //     $plant_id = isset($_GET['plant_id']) ? $_GET['plant_id'] : null;

    //     $technician = $this->findTechnicianById($id);

    //     if ($technician['company_id'] != $company_id) {
    //         echo json_encode(['errors' => ["Non puoi accedere ai tecnici di altre compagnie."]]);
    //         http_response_code(403);
    //         return;
    //     }

    //     if ($plant_id) {
    //         $plant = $this->findPlantById($plant_id);
    //         $last_position = $this->getLastPosition($technician['id']);
    //         if ($last_position) {
    //             $technician['distance_from_plant'] = $this->calculateDistance($last_position, $plant);
    //         }
    //     }

    //     header('Content-Type: application/json');
    //     echo json_encode($technician);
    //     return;
    // }

    // // Updates a usable technician
    // public function update($id)
    // {
    //     $company_id = $_POST['company_id']; // Replace this with actual user session or auth data
    //     $technician = $this->findTechnicianById($id);

    //     if ($technician['company_id'] != $company_id || !$technician['is_usable']) {
    //         echo json_encode(['errors' => ["Non puoi aggiornare i tecnici di altre compagnie."]]);
    //         http_response_code(403);
    //         return;
    //     }

    //     $sql = "UPDATE technicians SET name = :name, surname = :surname, phone = :phone, speciality = :speciality, technician_level_id = :technician_level_id WHERE id = :id";
    //     $statement = $this->pdo->prepare($sql);
    //     $statement->bindValue(':name', $_POST['name'], PDO::PARAM_STR);
    //     $statement->bindValue(':surname', $_POST['surname'], PDO::PARAM_STR);
    //     $statement->bindValue(':phone', $_POST['phone'], PDO::PARAM_STR);
    //     $statement->bindValue(':speciality', $_POST['speciality'], PDO::PARAM_STR);
    //     $statement->bindValue(':technician_level_id', $_POST['technician_level_id'], PDO::PARAM_INT);
    //     $statement->bindValue(':id', $id, PDO::PARAM_INT);

    //     if ($statement->execute()) {
    //         $updatedTechnician = $this->findTechnicianById($id);
    //         header('Content-Type: application/json');
    //         echo json_encode($updatedTechnician);
    //         http_response_code(201);
    //     } else {
    //         echo json_encode(['errors' => $statement->errorInfo()]);
    //         http_response_code(422);
    //     }
    //     return;
    // }

    // // Makes a technician no longer usable
    // public function destroy($id)
    // {
    //     $company_id = $_POST['company_id']; // Replace this with actual user session or auth data
    //     $technician = $this->findTechnicianById($id);

    //     if ($technician['company_id'] != $company_id || !$technician['is_usable']) {
    //         echo json_encode(['errors' => ["Non puoi congelare un tecnico di un'altra compagnia."]]);
    //         http_response_code(403);
    //         return;
    //     }

    //     if ($this->hasOpenInterventions($id)) {
    //         echo json_encode(['errors' => ["Non e' possibile congelare un tecnico con degli interventi assegnati"]]);
    //         http_response_code(422);
    //         return;
    //     }

    //     $sql = "UPDATE technicians SET is_usable = false, tokens = '{}' WHERE id = :id";
    //     $statement = $this->pdo->prepare($sql);
    //     $statement->bindValue(':id', $id, PDO::PARAM_INT);

    //     if ($statement->execute()) {
    //         http_response_code(204);
    //     } else {
    //         echo json_encode(['errors' => $statement->errorInfo()]);
    //         http_response_code(422);
    //     }
    //     return;
    // }

    // Helper methods
    private function findTechnicianById($id)
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];

        $sql = "SELECT 
            u.id,
        u.name,
        u.nickname,
        u.email,
        u.surname,
        u.phone,
        u.birthdate,
        u.role,
        u.speciality,
        u.current_state,
        u.type,
        t.id AS level_id,
        t.name AS level_name,
         comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
        FROM users u
         LEFT JOIN companies comp ON u.company_id = comp.id
        LEFT JOIN technician_levels t on t.id = u.technician_level_id
         LEFT JOIN plants p on p.maintainer_id=u.id
        WHERE type='Technician' AND u.is_usable = true AND u.company_id = :company_id
        and u.id=:tech_id
        ";


        $statement = $this->pdo->prepare($sql);
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->bindValue(':tech_id', $id, PDO::PARAM_INT);
        // if ($maintainer_id) {
        //     $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_INT);
        // }
        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        //$plants = [];
        //foreach ($results as $row) {

        //   $technician_id = $row['id'];
        $stmt = $this->pdo->prepare("SELECT count(id) as id_count FROM interventions WHERE  company_id = :company_id and type='OpenIntervention' and current_technician_id = :current_technician_id order by closed_at desc");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':current_technician_id', $id);
        $stmt->execute();
        $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
        $id_count = $plantsData['id_count'];



        $plant = [
            'id' => $row['id'],
            'name' => $row['name'],
            'nickname' => $row['nickname'],
            'email' => $row['email'],
            'surname' => $row['surname'],
            'phone' => $row['phone'],
            'birthdate' => $row['birthdate'],
            'role' => $row['role'],
            'speciality' => $row['speciality'],
            'current_state' => $row['current_state'],
            'type' => $row['type'],
            'open_interventions_count' => $id_count,
            'closed_interventions_count' => 0,
            'technician_level' => [
                'id' => $row['level_id'],
                'name' => $row['level_name']
            ],
            'company' => [
                'id' => $row['company_id'],
                'name' => $row['company_name'],
                'address' => [
                    'street' => $row['company_street'],
                    'number' => $row['company_number'],
                    'city' => $row['company_city'],
                    'cap' => $row['company_cap'],
                    'province' => $row['company_province'],
                    'country' => $row['company_country']
                ],
                'logo' => $row['company_logo'],
                'phone' => $row['company_phone']
            ]
        ];

        //   $technician_id = $row['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id order by created_at desc limit 1");
        $stmt->bindParam(':technician_id', $id);
        $stmt->execute();
        $geoData = $stmt->fetch(PDO::FETCH_ASSOC);
        $latitude = '';
        $longitude = '';
        $created_at = '';
        if ($geoData !== false && $geoData !== null) {

            $latitude = $geoData['latitude'];
            $longitude = $geoData['longitude'];
            $created_at = $geoData['created_at'];

        }
        $plant['position'] = [
            'latitude' => $latitude,
            'longitude' => $longitude,
            'created_at' => $created_at
        ];
        //$plants[] = $plant;
        //  }

        return $plant;
    }

    // private function findPlantById($id)
    // {
    //     $sql = "SELECT * FROM plants WHERE id = :id";
    //     $statement = $this->pdo->prepare($sql);
    //     $statement->bindValue(':id', $id, PDO::PARAM_INT);
    //     $statement->execute();
    //     return $statement->fetch(PDO::FETCH_ASSOC);
    // }

    // private function getLastPosition($technician_id)
    // {
    //     $sql = "SELECT latitude, longitude FROM positions WHERE technician_id = :technician_id ORDER BY created_at DESC LIMIT 1";
    //     $statement = $this->pdo->prepare($sql);
    //     $statement->bindValue(':technician_id', $technician_id, PDO::PARAM_INT);
    //     $statement->execute();
    //     return $statement->fetch(PDO::FETCH_ASSOC);
    // }

    // private function calculateDistance($last_position, $plant)
    // {
    //     // Haversine formula to calculate distance between two latitude-longitude points
    //     $earth_radius = 6371; // Radius in kilometers

    //     $lat_from = deg2rad($last_position['latitude']);
    //     $lon_from = deg2rad($last_position['longitude']);
    //     $lat_to = deg2rad($plant['latitude']);
    //     $lon_to = deg2rad($plant['longitude']);

    //     $lat_delta = $lat_to - $lat_from;
    //     $lon_delta = $lon_to - $lon_from;

    //     $angle = 2 * asin(sqrt(pow(sin($lat_delta / 2), 2) + cos($lat_from) * cos($lat_to) * pow(sin($lon_delta / 2), 2)));
    //     return $angle * $earth_radius;
    // }

    // private function hasOpenInterventions($technician_id)
    // {
    //     $sql = "SELECT COUNT(*) FROM interventions WHERE technician_id = :technician_id AND status = 'open'";
    //     $statement = $this->pdo->prepare($sql);
    //     $statement->bindValue(':technician_id', $technician_id, PDO::PARAM_INT);
    //     $statement->execute();
    //     return $statement->fetchColumn() > 0;
    // }

    // private function sendWelcomeMail($email)
    // {
    //     // Mail sending logic here
    // }

    // private function sendResetPasswordInstructions($email)
    // {
    //     // Password reset logic here
    // }
}
