<?php
require_once __DIR__ . '/../helpers/response.php';
// require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';
class PlantsController extends BaseController
{
    // private $pdo;
    public function __construct()
    {
        parent::__construct();
        // $this->pdo = require __DIR__ . '/../config/database.php';
    }

    // Returns the complete list of plants owned by the current user's company.
    // Send 'allow_inactive=true' parameter to include inactive plants
    public function index()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $usable = isset($_GET['usable']) ? $_GET['usable'] : 1;
        $rowsPerPage = 50;
        $offset = ($page - 1) * $rowsPerPage;

        $stmt = $this->pdo->prepare("SELECT count(p.id) total FROM plants p LEFT JOIN users m ON p.maintainer_id = m.id WHERE p.is_usable =:is_usable AND p.company_id = :company_id
                 AND (p.name LIKE :searchQuery OR p.street LIKE :searchQuery OR p.number LIKE :searchQuery OR p.city LIKE :searchQuery OR p.cap LIKE :searchQuery or m.name LIKE :searchQuery or m.surname LIKE :searchQuery)");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->bindParam(':is_usable', $usable);
        $stmt->bindParam(':searchQuery', $searchQuery);
        $stmt->execute();
        $totalData = $stmt->fetch(PDO::FETCH_ASSOC);

        $total = $totalData['total'];


        $querySQL = "
                SELECT 
                p.id,
                m.type,
                p.name,
                p.street,
                p.number,
                p.city,
                p.cap,
                p.province,
                p.streetview_img,
                p.country,
                p.latitude,
                p.longitude,
                p.typology,
                p.telephone,
                p.administrator,
                p.is_usable,
                p.company_id,
                p.created_at,
                p.updated_at,
                p.contract,
                p.note,
                p.code,
                p.matriculation,
                p.is_usable,
                m.id AS maintainer_id,
                m.name AS maintainer_name,
                m.surname AS maintainer_surname,
                m.type AS maintainer_type,
                comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
                FROM plants p
                LEFT JOIN users m ON p.maintainer_id = m.id
                LEFT JOIN companies comp ON p.company_id = comp.id
                WHERE p.is_usable =:is_usable AND p.company_id = :company_id
                 AND ( CONCAT(p.street, ' ', p.number, ' ', p.cap, ' ', p.city) LIKE :searchQuery OR p.name LIKE :searchQuery OR p.street LIKE :searchQuery OR p.number LIKE :searchQuery OR p.city LIKE :searchQuery OR p.cap LIKE :searchQuery or m.name LIKE :searchQuery or m.surname LIKE :searchQuery)
                 order by TRIM(p.street) 
                LIMIT :limit OFFSET :offset
            ";
        $statement = $this->pdo->prepare($querySQL);


        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindParam(':is_usable', $usable);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $plants = [];
        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'type' => $row['typology'],
                'address' => $row['street'] . " " . $row['number'] . ", " . $row['cap'] . " " . $row['city'] . ", " . $row['city'] . ", " . $row['country'],
                'admin' => $row['administrator'],
                'street' => $row['street'],
                'number' => $row['number'],
                'cap' => $row['cap'],
                'city' => $row['city'],
                'detail' => $row['name'],
                'latitude' => $row['latitude'],
                'longitude' => $row['longitude'],
                'last_closed_intervention' => 0,
                'maintainer' => [
                    'id' => $row['maintainer_id'],
                    'name' => $row['maintainer_name'],
                    'surname' => $row['maintainer_surname'],
                    'type' => $row['maintainer_type']
                ],
                'contract' => $row['contract'],
                'note' => $row['note'],
                'photos' => [],
                'matriculation' => $row['matriculation'],
                'is_usable' => $row['is_usable'],
                'code' => $row['code'],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'phone' => $row['company_phone']
                ],
                'streetview_url' => ''
            ];

            $plant_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM interventions WHERE plant_id = :plant_id and type='ClosedIntervention' order by closed_at desc limit 1");
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $plantsData = $stmt->fetchAll(PDO::FETCH_ASSOC);

            foreach ($plantsData as $planrow) {
                $plant['last_closed_intervention'] = [
                    'id' => $planrow['id'],
                    'admin_comment' => $planrow['admin_comment'],
                    'urgent' => $planrow['urgent'],
                    'viewed_by_technician' => $planrow['viewed_by_technician'],
                    'viewed_by_support_technician' => $planrow['viewed_by_support_technician'],
                    'viewed_by_admin' => $planrow['viewed_by_admin'],
                    'technician_distance_from_plant' => null,
                    'issue_id' => $planrow['issue_id'],
                    'plant_id' => $planrow['plant_id'],
                    'current_technician_id' => $planrow['current_technician_id'],
                    'current_support_technician_id' => $planrow['current_support_technician_id'],

                ];

                $intervention_id = $planrow['id'];
                $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id order by id desc");
                $stmt->bindParam(':intervention_id', $intervention_id);
                $stmt->execute();
                $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                foreach ($eventsData as $eventrow) {
                    $plant['last_closed_intervention']['intervention_events'][] = [
                        'id' => $eventrow['id'],
                        'intervention_id' => $eventrow['intervention_id'],
                        'technician_id' => $eventrow['technician_id'],
                        'admin_id' => $eventrow['admin_id'],
                        'type' => $eventrow['type'],
                        'created_at' => $eventrow['event_created_at'],
                    ];
                }
                $plant['streetview_url'] = 'https://maps.googleapis.com/maps/api/streetview?size=506x248&location=' . $plant['address'] . '&key=' . $this->GOOGLE_MAPS_API_KEY;

            }

            // 'company' => [
            //         'id' => $row['company_id'],
            //         'name' => $row['company_name'],
            //         'address' => [
            //             'street' => $row['company_street'],
            //             'number' => $row['company_number'],
            //             'city' => $row['company_city'],
            //             'cap' => $row['company_cap'],
            //             'province' => $row['company_province'],
            //             'country' => $row['company_country']
            //         ],
            //         'logo' => $row['company_logo'],
            //         'phone' => $row['company_phone']

            // Append the intervention to the interventions array
            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('access-control-allow-credentials: true');
        header('Access-Control-Expose-Headers: Access-Token, Client, Token-Type, Uid, total, per-page');
        header('Content-Type: application/json');
        header('total: ' . $total);
        header('per-page: ' . $rowsPerPage);
        echo $json;
        return;

    }

    public function getPlantsById($plantId)
    {
        $querySQL = "
                SELECT 
                p.id,
                m.type,
                p.name,
                p.street,
                p.number,
                p.city,
                p.cap,
                p.province,
                p.streetview_img,
                p.country,
                p.latitude,
                p.longitude,
                p.typology,
                p.telephone,
                p.administrator,
                p.is_usable,
                p.company_id,
                p.created_at,
                p.updated_at,
                p.contract,
                p.note,
                p.code,
                p.matriculation,
                p.is_usable,
                m.id AS maintainer_id,
                m.name AS maintainer_name,
                m.surname AS maintainer_surname,
                m.type AS maintainer_type,
                comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
                FROM plants p
                LEFT JOIN users m ON p.maintainer_id = m.id
                LEFT JOIN companies comp ON p.company_id = comp.id
                WHERE  p.id=:plant_id
            ";
        // p.is_usable = 1 AND p.company_id = :company_id and

        $statement = $this->pdo->prepare($querySQL);

        $statement->bindValue(':plant_id', $plantId, PDO::PARAM_STR);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        // $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        // $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        // $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);


        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'type' => $row['typology'],
                'address' => $row['street'] . " " . $row['number'] . ", " . $row['cap'] . " " . $row['city'] . ", " . $row['city'] . ", " . $row['country'],
                'admin' => $row['administrator'],
                'street' => $row['street'],
                'number' => $row['number'],
                'cap' => $row['cap'],
                'city' => $row['city'],
                'detail' => $row['name'],
                'latitude' => $row['latitude'],
                'longitude' => $row['longitude'],
                'last_closed_intervention' => 0,
                'maintainer' => [
                    'id' => $row['maintainer_id'],
                    'name' => $row['maintainer_name'],
                    'surname' => $row['maintainer_surname'],
                    'type' => $row['maintainer_type']
                ],
                'contract' => $row['contract'],
                'note' => $row['note'],
                'photos' => [],
                'matriculation' => $row['matriculation'],
                'code' => $row['code'],
                'is_usable' => $row['is_usable'],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],//have to add Logo
                    'phone' => $row['company_phone']
                ],
                'streetview_url' => ""//have to add google map link
            ];


            $plant_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM plant_photos WHERE plant_id = :plant_id");
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $photosData = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($photosData as $photorow) {
                $plant['photos'][] = [
                    'id' => $photorow['id'],
                    'url' => $this->SITE_URL . '/uploads/plant_photo/data/' . $photorow['id'] . '/' . $photorow['data']
                ];
            }
            //  $intervention['notes'][] = $note;

            $plant_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM interventions WHERE plant_id = :plant_id and type='ClosedIntervention' order by closed_at desc limit 1");
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $planrow = $stmt->fetch(PDO::FETCH_ASSOC);

            //foreach ($plantsData as $planrow) {
            if ($planrow) {
                $plant['last_closed_intervention'] = [
                    'id' => $planrow['id'],
                    'admin_comment' => $planrow['admin_comment'],
                    'urgent' => $planrow['urgent'],
                    'viewed_by_technician' => $planrow['viewed_by_technician'],
                    'viewed_by_support_technician' => $planrow['viewed_by_support_technician'],
                    'viewed_by_admin' => $planrow['viewed_by_admin'],
                    'technician_distance_from_plant' => null,
                    'issue_id' => $planrow['issue_id'],
                    'plant_id' => $planrow['plant_id'],
                    'current_technician_id' => $planrow['current_technician_id'],
                    'current_support_technician_id' => $planrow['current_support_technician_id'],

                ];


                $intervention_id = $planrow['id'];
                $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id order by id desc");
                $stmt->bindParam(':intervention_id', $intervention_id);
                $stmt->execute();
                $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                foreach ($eventsData as $eventrow) {
                    $plant['last_closed_intervention']['intervention_events'][] = [
                        'id' => $eventrow['id'],
                        'intervention_id' => $eventrow['intervention_id'],
                        'technician_id' => $eventrow['technician_id'],
                        'admin_id' => $eventrow['admin_id'],
                        'type' => $eventrow['type'],
                        'created_at' => $eventrow['event_created_at'],
                    ];
                }
            }
        }

        $json = json_encode($plant, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;

    }

    public function createAppointment($plant_id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $title = isset($postData['title']) ? $postData['title'] : '';
                    $type = isset($postData['type']) ? "Open" . $postData['type'] : 'OpenAppointment';
                    $description = isset($postData['description']) ? $postData['description'] : '';
                    $periodicity = isset($postData['periodicity']) && $postData['periodicity'] != "" ? $postData['periodicity'] : 'semiannual';
                    $date = isset($postData['date']) ? $postData['date'] : '';
                    // $plant_id = isset($postData['plant_id']) ? $postData['plant_id'] : null;
                    //$current_technician_id = isset($postData['current_technician_id']) ? $postData['current_technician_id'] : null;
                    $current_technician = isset($postData['current_technician_id']) ? $postData['current_technician_id'] : (isset($postData['current_technician']) ? $postData['current_technician'] : null);




                    $sql = "INSERT INTO deadlines (type, title, description, periodicity, date, plant_id, current_technician_id, company_id, created_at, updated_at) 
                        VALUES (:type, :title, :description, :periodicity, :date, :plant_id, :current_technician_id, :company_id, now(), now())";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':type', $type, PDO::PARAM_STR);
                    $statement->bindValue(':title', $title, PDO::PARAM_STR);
                    $statement->bindValue(':description', $description, PDO::PARAM_STR);
                    $statement->bindValue(':periodicity', $periodicity);
                    $statement->bindValue(':date', $date);
                    $statement->bindValue(':plant_id', $plant_id, PDO::PARAM_INT);
                    $statement->bindValue(':current_technician_id', $current_technician, PDO::PARAM_INT);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);

                    if ($statement->execute()) {
                        // Return a success response
                        $response = [
                            'status' => 'success',
                            'message' => 'Created successfully.'
                        ];
                        http_response_code(201);
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create.'
                        ];
                        http_response_code(422);
                    }
                    // Return the response as JSON
                    header('Content-Type: application/json');
                    echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                    http_response_code(400);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
                http_response_code(415);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
            http_response_code(405);
        }
    }
    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $administrator = isset($postData['administrator']) ? $postData['administrator'] : '';
                    $cap = isset($postData['cap']) ? $postData['cap'] : '';
                    $city = isset($postData['city']) ? $postData['city'] : '';
                    $code = isset($postData['code']) ? $postData['code'] : '';
                    $contract = isset($postData['contract']) ? $postData['contract'] : '';
                    $country = isset($postData['country']) ? $postData['country'] : '';
                    $latitude = isset($postData['latitude']) ? $postData['latitude'] : '';
                    $longitude = isset($postData['longitude']) ? $postData['longitude'] : '';
                    $matriculation = isset($postData['matriculation']) ? $postData['matriculation'] : '';
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $maintainer_id = isset($postData['maintainer_id']) ? $postData['maintainer_id'] : null;
                    $note = isset($postData['note']) ? $postData['note'] : '';
                    $number = isset($postData['number']) ? $postData['number'] : '';
                    $province = isset($postData['province']) ? $postData['province'] : '';
                    $street = isset($postData['street']) ? $postData['street'] : '';
                    $streetview_img = isset($postData['streetview_img']) ? $postData['streetview_img'] : '';
                    $telephone = isset($postData['telephone']) ? $postData['telephone'] : null;
                    $typology = isset($postData['typology']) ? $postData['typology'] : '';

                    $sql = "INSERT INTO plants (name,
                        street,
                        number,
                        city,
                        cap,
                        province,
                        streetview_img,
                        country,
                        latitude,
                        longitude,
                        typology,
                        telephone,
                        administrator,
                        maintainer_id,
                        company_id,
                        created_at,
                        updated_at,
                        contract,
                        note,
                        code,
                        matriculation) 
                        VALUES (:name,
                        :street,
                        :number,
                        :city,
                        :cap,
                        :province,
                        :streetview_img,
                        :country,
                        :latitude,
                        :longitude,
                        :typology,
                        :telephone,
                        :administrator,
                        :maintainer_id,
                        :company_id,
                        now(),
                        now(),
                        :contract,
                        :note,
                        :code,
                        :matriculation)";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':street', $street, PDO::PARAM_STR);
                    $statement->bindValue(':number', $number, PDO::PARAM_STR);
                    $statement->bindValue(':city', $city);
                    $statement->bindValue(':cap', $cap);
                    $statement->bindValue(':province', $province, PDO::PARAM_STR);
                    $statement->bindValue(':streetview_img', $streetview_img, PDO::PARAM_STR);
                    $statement->bindValue(':country', $country, PDO::PARAM_STR);
                    $statement->bindValue(':latitude', $latitude, PDO::PARAM_STR);
                    $statement->bindValue(':longitude', $longitude, PDO::PARAM_STR);
                    $statement->bindValue(':typology', $typology, PDO::PARAM_STR);
                    $statement->bindValue(':telephone', $telephone, PDO::PARAM_STR);
                    $statement->bindValue(':administrator', $administrator, PDO::PARAM_STR);
                    $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_STR);
                    $statement->bindValue(':contract', $contract, PDO::PARAM_STR);
                    $statement->bindValue(':note', $note, PDO::PARAM_STR);
                    $statement->bindValue(':code', $code, PDO::PARAM_STR);
                    $statement->bindValue(':matriculation', $matriculation, PDO::PARAM_STR);


                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    if ($statement->execute()) {
                        // Assuming sendWelcomeMail() and sendResetPasswordInstructions() are functions defined elsewhere
                        $technician_id = $this->pdo->lastInsertId();
                        // $this->sendWelcomeMail($email);
                        // $this->sendResetPasswordInstructions($email);

                        $technician = $this->findPlantById($technician_id);
                        header('Content-Type: application/json');
                        http_response_code(201);
                        echo json_encode($technician);
                    } else {
                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                    }
                    // if ($statement->execute()) {
                    //     // Return a success response
                    //     $response = [
                    //         'status' => 'success',
                    //         'message' => 'Created successfully.'
                    //     ];
                    //     http_response_code(201);
                    // } else {
                    //     // Return an error response
                    //     $response = [
                    //         'status' => 'error',
                    //         'message' => 'Failed to create.'
                    //     ];
                    //     http_response_code(422);
                    // }
                    // // Return the response as JSON
                    // header('Content-Type: application/json');
                    // echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                    http_response_code(400);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
                http_response_code(415);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
            http_response_code(405);
        }
    }

    private function findPlantById($id)
    {
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];

        $querySQL = "
                SELECT 
                p.id,
                m.type,
                p.name,
                p.street,
                p.number,
                p.city,
                p.cap,
                p.province,
                p.streetview_img,
                p.country,
                p.latitude,
                p.longitude,
                p.typology,
                p.telephone,
                p.administrator,
                p.is_usable,
                p.company_id,
                p.created_at,
                p.updated_at,
                p.contract,
                p.note,
                p.code,
                p.matriculation,
                m.id AS maintainer_id,
                m.name AS maintainer_name,
                m.surname AS maintainer_surname,
                m.type AS maintainer_type,
                comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
                FROM plants p
                LEFT JOIN users m ON p.maintainer_id = m.id
                LEFT JOIN companies comp ON p.company_id = comp.id
                WHERE p.id=:plant_id
            ";
        //  p.is_usable = 1 AND p.company_id = :company_id and
        $statement = $this->pdo->prepare($querySQL);

        $statement->bindValue(':plant_id', $id, PDO::PARAM_STR);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        // $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        // $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        // $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);



        // $plants = [];
        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'type' => $row['type'],
                'address' => $row['street'] . " " . $row['number'] . ", " . $row['cap'] . " " . $row['city'] . ", " . $row['city'] . ", " . $row['country'],
                'admin' => $row['administrator'],
                'street' => $row['street'],
                'number' => $row['number'],
                'cap' => $row['cap'],
                'city' => $row['city'],
                'detail' => $row['name'],
                'latitude' => $row['latitude'],
                'longitude' => $row['longitude'],
                'maintainer' => [
                    'id' => $row['maintainer_id'],
                    'name' => $row['maintainer_name'],
                    'surname' => $row['maintainer_surname'],
                    'type' => $row['maintainer_type']
                ],
                'contract' => $row['contract'],
                'note' => $row['note'],
                'photos' => [],
                'matriculation' => $row['matriculation'],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],//have to add Logo
                    'phone' => $row['company_phone']
                ],
                'streetview_url' => ""//have to add google map link
            ];

            $plant_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM interventions WHERE plant_id = :plant_id and type='ClosedIntervention' order by closed_at desc limit 1");
            $stmt->bindParam(':plant_id', $plant_id);
            $stmt->execute();
            $planrow = $stmt->fetch(PDO::FETCH_ASSOC);
            $plant['last_closed_intervention'] = [];
            //foreach ($plantsData as $planrow) {
            if ($planrow != null) {
                $plant['last_closed_intervention'] = [
                    'id' => $planrow['id'],
                    'admin_comment' => $planrow['admin_comment'],
                    'urgent' => $planrow['urgent'],
                    'viewed_by_technician' => $planrow['viewed_by_technician'],
                    'viewed_by_support_technician' => $planrow['viewed_by_support_technician'],
                    'viewed_by_admin' => $planrow['viewed_by_admin'],
                    'technician_distance_from_plant' => null,
                    'issue_id' => $planrow['issue_id'],
                    'plant_id' => $planrow['plant_id'],
                    'current_technician_id' => $planrow['current_technician_id'],
                    'current_support_technician_id' => $planrow['current_support_technician_id'],

                ];


                $intervention_id = $planrow['id'];
                $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id order by id desc");
                $stmt->bindParam(':intervention_id', $intervention_id);
                $stmt->execute();
                $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                foreach ($eventsData as $eventrow) {
                    $plant['last_closed_intervention']['intervention_events'][] = [
                        'id' => $eventrow['id'],
                        'intervention_id' => $eventrow['intervention_id'],
                        'technician_id' => $eventrow['technician_id'],
                        'admin_id' => $eventrow['admin_id'],
                        'type' => $eventrow['type'],
                        'created_at' => $eventrow['event_created_at'],
                    ];
                }
            }
        }
        return $plant;
    }

    public function update($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'PATCH') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    // $companyObject = $this->currentUserCompany;
                    // $company_id = $companyObject['id'];
                    $administrator = isset($postData['administrator']) ? $postData['administrator'] : '';
                    $cap = isset($postData['cap']) ? $postData['cap'] : '';
                    $city = isset($postData['city']) ? $postData['city'] : '';
                    $code = isset($postData['code']) ? $postData['code'] : '';
                    $contract = isset($postData['contract']) ? $postData['contract'] : '';
                    $country = isset($postData['country']) ? $postData['country'] : '';
                    $latitude = isset($postData['latitude']) ? $postData['latitude'] : '';
                    $longitude = isset($postData['longitude']) ? $postData['longitude'] : '';
                    $matriculation = isset($postData['matriculation']) ? $postData['matriculation'] : '';
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $maintainer_id = isset($postData['maintainer_id']) ? $postData['maintainer_id'] : null;
                    $note = isset($postData['note']) ? $postData['note'] : '';
                    $number = isset($postData['number']) ? $postData['number'] : '';
                    $province = isset($postData['province']) ? $postData['province'] : '';
                    $street = isset($postData['street']) ? $postData['street'] : '';
                    $streetview_img = isset($postData['streetview_img']) ? $postData['streetview_img'] : '';
                    $telephone = isset($postData['telephone']) ? $postData['telephone'] : null;
                    $typology = isset($postData['typology']) ? $postData['typology'] : '';


                    $sql = "UPDATE plants set name=:name,
                        street=:street,
                        number=:number,
                        city=:city,
                        cap=:cap,
                        province=:province,
                        streetview_img=:streetview_img,
                        country=:country,
                        latitude=:latitude,
                        longitude=:longitude,
                        typology=:typology,
                        telephone=:telephone,
                        administrator=:administrator,
                        maintainer_id=:maintainer_id,
                        updated_at=now(),
                        contract=:contract,
                        note=:note,
                        code=:code,
                        matriculation=:matriculation 
                         WHERE id = :id";
                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':street', $street, PDO::PARAM_STR);
                    $statement->bindValue(':number', $number, PDO::PARAM_STR);
                    $statement->bindValue(':city', $city);
                    $statement->bindValue(':cap', $cap);
                    $statement->bindValue(':province', $province, PDO::PARAM_STR);
                    $statement->bindValue(':streetview_img', $streetview_img, PDO::PARAM_STR);
                    $statement->bindValue(':country', $country, PDO::PARAM_STR);
                    $statement->bindValue(':latitude', $latitude, PDO::PARAM_STR);
                    $statement->bindValue(':longitude', $longitude, PDO::PARAM_STR);
                    $statement->bindValue(':typology', $typology, PDO::PARAM_STR);
                    $statement->bindValue(':telephone', $telephone, PDO::PARAM_STR);
                    $statement->bindValue(':administrator', $administrator, PDO::PARAM_STR);
                    $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_STR);
                    $statement->bindValue(':contract', $contract, PDO::PARAM_STR);
                    $statement->bindValue(':note', $note, PDO::PARAM_STR);
                    $statement->bindValue(':code', $code, PDO::PARAM_STR);
                    $statement->bindValue(':matriculation', $matriculation, PDO::PARAM_STR);
                    $statement->bindValue(':id', $id, PDO::PARAM_INT);

                    // $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    if ($statement->execute()) {
                        // Assuming sendWelcomeMail() and sendResetPasswordInstructions() are functions defined elsewhere
                        // $technician_id = $this->pdo->lastInsertId();
                        // $this->sendWelcomeMail($email);
                        // $this->sendResetPasswordInstructions($email);

                        $technician = $this->findPlantById($id);
                        header('Content-Type: application/json');
                        http_response_code(201);
                        echo json_encode($technician);
                    } else {
                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                    }
                    // if ($statement->execute()) {
                    //     // Return a success response
                    //     $response = [
                    //         'status' => 'success',
                    //         'message' => 'Created successfully.'
                    //     ];
                    //     http_response_code(201);
                    // } else {
                    //     // Return an error response
                    //     $response = [
                    //         'status' => 'error',
                    //         'message' => 'Failed to create.'
                    //     ];
                    //     http_response_code(422);
                    // }
                    // // Return the response as JSON
                    // header('Content-Type: application/json');
                    // echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                    http_response_code(400);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
                http_response_code(415);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be PATCH'
            ]);
            http_response_code(405);
        }
    }

    public function distroyDeadline($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {


            // $sql = "UPDATE users SET is_usable = false, tokens = '{}' WHERE id = :id";
            $sql = "DELETE FROM deadlines WHERE id = :id";

            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create intervention.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }

    public function distroy($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $companyObject = $this->currentUserCompany;
            $company_id = $companyObject['id'];

            $stmt = $this->pdo->prepare("SELECT is_usable FROM plants WHERE id =:id ");
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            $plantData = $stmt->fetch(PDO::FETCH_ASSOC);

            $is_usable = $plantData['is_usable'];
            $sql = "";
            if ($is_usable == 1) {
                $sql = "UPDATE plants SET is_usable = false WHERE id = :id";
            } else {
                $sql = "UPDATE plants SET is_usable = true WHERE id = :id";
            }

            // $sql = "UPDATE users SET is_usable = false, tokens = '{}' WHERE id = :id";
            //$sql = "DELETE FROM plants WHERE id = :id";

            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Techinician deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create intervention.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }
    public function uploadPlanPhoto($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $input = file_get_contents('php://input');
            $data = json_decode($input, true);

            // Check if 'image' data is provided
            if (isset($data['data'])) {
                $imageData = $data['data'];

                // Extract the base64 data part
                list($type, $imageData) = explode(';', $imageData);
                list(, $imageData) = explode(',', $imageData);

                // Decode the base64 data
                $decodedData = base64_decode($imageData);
                $fileName = 'data.jpeg';
                // Save the image path to the database (optional)
                $stmt = $this->pdo->prepare("INSERT INTO `plant_photos`(`plant_id`, `data`, `created_at`, `updated_at`) VALUES (:id, :photo,
                now(),
                now())");
                $stmt->bindParam(':photo', $fileName);
                $stmt->bindParam(':id', $id);
                $stmt->execute();
                $image_id = $this->pdo->lastInsertId();

                // Define the directory to save the photo
                $uploadDir = __DIR__ . '/../uploads/plant_photo/data/' . $image_id . '/';
                if (!file_exists($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }

                // Save the image with a unique filename

                $filePath = $uploadDir . $fileName;

                if (file_put_contents($filePath, $decodedData)) {

                    // Return success response
                    echo json_encode(['status' => 'success', 'message' => 'Photo uploaded successfully!', 'file' => $fileName]);
                } else {
                    // Return error response if saving the file fails
                    echo json_encode(['status' => 'error', 'message' => 'Failed to save the photo.']);
                }
            } else {
                // Return error response if the image is missing
                echo json_encode(['status' => 'error', 'message' => 'No image data provided.']);
            }
        } else {
            // Return error response for non-POST requests
            echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
        }
    }


    // // Returns a plant, whether it is usable or not
    // public function show($id)
    // {
    //     $stmt = $this->pdo->prepare("
    //         SELECT * FROM plants
    //         WHERE id = :id AND company_id = :company_id
    //     ");
    //     $stmt->execute(['id' => $id, 'company_id' => $this->company_id]);
    //     $plant = $stmt->fetch(PDO::FETCH_ASSOC);

    //     if ($plant) {
    //         echo json_encode($plant);
    //     } else {
    //         echo json_encode(['errors' => ["Non puoi accedere agli impianti di altre compagnie."]], JSON_PRETTY_PRINT);
    //     }
    // }

    // // Updates a plant. Only usable plants can be updated.
    // public function update($id)
    // {
    //     $stmt = $this->pdo->prepare("
    //         SELECT * FROM plants
    //         WHERE id = :id AND is_usable = 1 AND company_id = :company_id
    //     ");
    //     $stmt->execute(['id' => $id, 'company_id' => $this->company_id]);
    //     $plant = $stmt->fetch(PDO::FETCH_ASSOC);

    //     if ($plant) {
    //         $params = $this->plant_params();
    //         $set_clause = implode(", ", array_map(fn($key) => "$key = :$key", array_keys($params)));
    //         $params['id'] = $id;

    //         $stmt = $this->pdo->prepare("UPDATE plants SET $set_clause WHERE id = :id");
    //         if ($stmt->execute($params)) {
    //             echo json_encode($plant);
    //         } else {
    //             echo json_encode(['errors' => $stmt->errorInfo()]);
    //         }
    //     } else {
    //         echo json_encode(['errors' => ["Non puoi aggiornare gli impianti di altre compagnie."]]);
    //     }
    // }

    // // Makes a plant no more selectable. Plants will never be destroyed due to their links with interventions and technicians
    // public function destroy($id)
    // {
    //     $stmt = $this->pdo->prepare("
    //         SELECT * FROM plants
    //         WHERE id = :id AND is_usable = 1 AND company_id = :company_id
    //     ");
    //     $stmt->execute(['id' => $id, 'company_id' => $this->company_id]);
    //     $plant = $stmt->fetch(PDO::FETCH_ASSOC);

    //     if ($plant) {
    //         $stmt = $this->pdo->prepare("UPDATE plants SET is_usable = 0 WHERE id = :id");
    //         if ($stmt->execute(['id' => $id])) {
    //             http_response_code(204);
    //         } else {
    //             echo json_encode(['errors' => $stmt->errorInfo()]);
    //         }
    //     } else {
    //         echo json_encode(['errors' => ["Non puoi congelare gli impianti di altre compagnie."]]);
    //     }
    // }

    // // Imports new plants
    // public function import()
    // {
    //     $stmt = $this->pdo->prepare("
    //         SELECT * FROM technicians
    //         WHERE company_id = :company_id
    //         LIMIT 1
    //     ");
    //     $stmt->execute(['company_id' => $this->company_id]);
    //     $first_technician = $stmt->fetch(PDO::FETCH_ASSOC);

    //     if (!$first_technician) {
    //         echo json_encode(['errors' => "Prima di importare degli impianti è necessario creare almeno un tecnico al fine di poterlo impostare come manutentore."], JSON_PRETTY_PRINT);
    //         http_response_code(412);
    //         return;
    //     }

    //     // Assuming `data` is properly sanitized or use prepared statements if this is dynamic
    //     $data = '{"address_components":[{"long_name":"18","short_name":"18","types":["street_number"]}, ... ]';

    //     // Call to job for processing import in the background
    //     ImportPlantsJob::dispatch($_POST['data'], $_POST['filename'], $this->current_user, $data);

    //     http_response_code(204);
    // }

    // private function plant_params()
    // {
    //     return array_intersect_key($_POST, array_flip([
    //         'name',
    //         'street',
    //         'number',
    //         'city',
    //         'cap',
    //         'province',
    //         'streetview_img',
    //         'country',
    //         'latitude',
    //         'longitude',
    //         'typology',
    //         'telephone',
    //         'administrator',
    //         'maintainer_id',
    //         'company_id',
    //         'query',
    //         'contract',
    //         'note',
    //         'code',
    //         'matriculation',
    //         'from_lat',
    //         'from_lon',
    //         'to_lat',
    //         'to_lon'
    //     ]));
    // }

    // private function perform_search($query)
    // {
    //     $stmt1 = "
    //         SELECT * FROM plants
    //         WHERE is_usable = 1 AND company_id = :company_id
    //         AND street LIKE :query
    //         ORDER BY street
    //     ";
    //     $stmt2 = "
    //         SELECT * FROM plants
    //         WHERE is_usable = 1 AND company_id = :company_id
    //         AND CONCAT(TRIM(street), ' ', TRIM(number)) LIKE :query
    //         AND street NOT LIKE :query
    //         ORDER BY street
    //     ";

    //     return "($stmt1) UNION ALL ($stmt2)";
    // }
}
