<?php
require_once __DIR__ . '/../helpers/response.php';
require_once __DIR__ . '/BaseController.php';
class IssueController extends BaseController
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;


        $querySQL = "
                SELECT 
                i.*,
                comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country,
                comp.latitude,
                comp.longitude
                FROM issues i
                inner JOIN companies comp ON i.company_id = comp.id
                WHERE i.is_usable = 1 AND i.company_id = :company_id
                order by i.id 
                LIMIT :limit OFFSET :offset
            ";
        $statement = $this->pdo->prepare($querySQL);


        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        // $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);



        $plants = [];
        foreach ($results as $row) {
            $plant = [
                'id' => $row['id'],
                'name' => $row['name'],
                'position' => $row['position'],
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'technicians_count' => 0,
                    'admins_count' => 0,
                    'phone' => $row['company_phone'],
                    'latitude' => $row['latitude'],
                    'longitude' => $row['longitude'],

                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'streetview_url' => '',
                ]
            ];



            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;

    }
    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $position = isset($postData['position']) ? $postData['position'] : '';


                    $sql = "INSERT INTO issues (name, position, company_id, created_at, updated_at) 
                VALUES (:name, :position, :company_id, now(), now())";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':position', $position, PDO::PARAM_STR);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);

                    if ($statement->execute()) {

                        // Get the last inserted ID
                        $lastInsertId = $this->pdo->lastInsertId();

                        // Retrieve the last inserted item
                        $fetchSql = "SELECT * FROM issues WHERE id = :id";
                        $fetchStatement = $this->pdo->prepare($fetchSql);
                        $fetchStatement->bindValue(':id', $lastInsertId, PDO::PARAM_INT);
                        $fetchStatement->execute();

                        // Fetch the inserted item as an associative array
                        $response = $fetchStatement->fetch(PDO::FETCH_ASSOC);
                        // Return the response as JSON
                        header('Content-Type: application/json');
                        echo json_encode($response);

                        // // Return a success response
                        // $response = [
                        //     'status' => 'success',
                        //     'message' => 'Created successfully.'
                        // ];
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create.'
                        ];
                        header('Content-Type: application/json');
                        echo json_encode($response);
                    }
                    // // Return the response as JSON
                    // header('Content-Type: application/json');
                    // echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }

}
