<?php
require_once __DIR__ . '/../helpers/response.php';
require_once __DIR__ . '/BaseController.php';


class InterventionsController extends BaseController
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getInterventionsByIdType($technicianId, $interventionType)
    {
        $companyObject = $this->currentUserCompany;
        $company_id = $companyObject['id'];
        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $only_support = isset($_GET['only_support']) ? (int) $_GET['only_support'] : false;
        $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;
        $intervType = "OpenIntervention";
        if ($interventionType == "open_interventions") {
            $intervType = "OpenIntervention";
        } else if ($interventionType == "closed_interventions") {
            $intervType = "ClosedIntervention";
        }
        $querySQL = "
            SELECT i.id AS intervention_id,
        i.admin_comment,
        i.urgent,
        i.viewed_by_technician,
        i.viewed_by_support_technician,
        i.viewed_by_admin,
        issue.id AS issue_id,
        issue.name AS issue_name,
        issue.position AS issue_position,
            plant.id AS plant_id,
        plant.street AS plant_street,
        plant.number AS plant_number,
        plant.cap AS plant_cap,
        plant.city AS plant_city,
        plant.contract AS plant_contract,
        plant.matriculation AS plant_matriculation,
        plant.code AS plant_code,
        plant.latitude AS plant_latitude,
        plant.longitude AS plant_longitude,
        tech.id AS technician_id,
        tech.name AS technician_name,
        tech.surname AS technician_surname,
        supp_tech.id AS support_technician_id,
        supp_tech.name AS support_technician_name,
        supp_tech.surname AS support_technician_surname,
        evt.id AS event_id,
        evt.type AS event_type,
        DATE_FORMAT(evt.created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at,
        comp.id AS company_id,
        comp.name AS company_name,
        comp.phone AS company_phone,
        comp.logo AS company_logo,
        comp.street AS company_street,
        comp.number AS company_number,
        comp.city AS company_city,
        comp.cap AS company_cap,
        comp.province AS company_province,
        comp.country AS company_country
            FROM interventions i
            LEFT JOIN issues issue ON i.issue_id = issue.id
            LEFT JOIN plants plant ON i.plant_id = plant.id
            LEFT JOIN users tech ON i.current_technician_id = tech.id
            LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
            LEFT JOIN intervention_events evt ON i.id = evt.intervention_id
            LEFT JOIN notes ON i.id = notes.intervention_id
            LEFT JOIN companies comp ON i.company_id = comp.id
            WHERE i.is_usable = true and i.current_technician_id=:technicianId
            and i.company_id=:company_id and i.type=:intervType 
            AND (plant.street LIKE :searchQuery OR plant.number LIKE :searchQuery)
            LIMIT :limit OFFSET :offset";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters 
        $statement->bindValue(':technicianId', $technicianId, PDO::PARAM_INT);
        $statement->bindValue(':intervType', $intervType, PDO::PARAM_STR);
        $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $interventions = [];
        foreach ($results as $row) {
            // Prepare the intervention data
            $intervention = [
                'id' => $row['intervention_id'],
                'admin_comment' => $row['admin_comment'],
                'urgent' => $row['urgent'] == 1,
                'viewed_by_technician' => $row['viewed_by_technician'] == 1,
                'viewed_by_support_technician' => $row['viewed_by_support_technician'] == 1,
                'viewed_by_admin' => $row['viewed_by_admin'] == 1,
                'notes' => [], // Assuming notes are fetched elsewhere
                'technician_distance_from_plant' => null, // Set this if you have the data
                'issue' => [
                    'id' => $row['issue_id'],
                    'name' => $row['issue_name'],
                    'position' => $row['issue_position']
                ],
                'plant' => [
                    'id' => $row['plant_id'],
                    'address' => '',
                    'street' => $row['plant_street'],
                    'number' => $row['plant_number'],
                    'cap' => $row['plant_cap'],
                    'city' => $row['plant_city'],
                    'detail' => '',
                    'contract' => $row['plant_contract'],
                    'matriculation' => $row['plant_matriculation'],
                    'code' => $row['plant_code'],
                    'streetview_url' => ''
                ],
                'current_technician' => [
                    'id' => $row['technician_id'],
                    'name' => $row['technician_name'],
                    'surname' => $row['technician_surname'],
                    'type' => 'technician'
                ],
                'current_support_technician' => $row['support_technician_id'] ? [
                    'id' => $row['support_technician_id'],
                    'name' => $row['support_technician_name'],
                    'surname' => $row['support_technician_surname'],
                    'type' => 'support_technician'
                ] : null,
                'intervention_events' => [
                    [
                        'id' => $row['event_id'],
                        'intervention_id' => $row['intervention_id'],
                        'technician_id' => $row['technician_id'],
                        'support_technician_id' => $row['support_technician_id'],
                        'admin_id' => 54, // Replace with actual admin ID
                        'type' => $row['event_type'],
                        'created_at' => $row['event_created_at']
                    ]
                ],
                'type' => 'OpenIntervention', // Adjust this as needed
                'report' => null, // Set this if you have the data
                'report_digital_signature' => null, // Set this if you have the data
                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'phone' => $row['company_phone']
                ]
            ];

            // Append the intervention to the interventions array
            $interventions[] = $intervention;
        }

        // Convert the array to JSON
        $json = json_encode($interventions, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;

    }


    public function create()
    {
        // Check if the request method is POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $userObject = $this->currentUser;
                    $admin_id = $userObject['id'];
                    $admin_comment = isset($postData['admin_comment']) ? $postData['admin_comment'] : '';
                    $current_technician_id = isset($postData['current_technician_id']) ? (int) $postData['current_technician_id'] : null;
                    $issue_id = isset($postData['issue_id']) ? (int) $postData['issue_id'] : null;
                    $plant_id = isset($postData['plant_id']) ? (int) $postData['plant_id'] : null;
                    $urgent = isset($postData['urgent']) ? filter_var($postData['urgent'], FILTER_VALIDATE_BOOLEAN) : false;

                    $querySQL = "INSERT INTO
                        interventions (admin_comment, current_technician_id, issue_id, plant_id, urgent, company_id, created_at, updated_at, type)
                       VALUES (:admin_comment, :current_technician_id, :issue_id, :plant_id, :urgent, :company_id, now(), now(), 'OpenIntervention')";

                    // Prepare the statement
                    $statement = $this->pdo->prepare($querySQL);

                    // Bind the parameters
                    $statement->bindValue(':admin_comment', $admin_comment, PDO::PARAM_STR);
                    $statement->bindValue(':current_technician_id', $current_technician_id, PDO::PARAM_INT);
                    $statement->bindValue(':issue_id', $issue_id, PDO::PARAM_INT);
                    $statement->bindValue(':plant_id', $plant_id, PDO::PARAM_INT);
                    $statement->bindValue(':urgent', $urgent);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);

                    // Execute the query
                    if ($statement->execute()) {
                        $intervention_id = $this->pdo->lastInsertId();
                        $querySQL = "INSERT INTO
                        intervention_events (intervention_id, technician_id, admin_id, type, created_at, updated_at)
                       VALUES (:intervention_id, :current_technician_id, :admin_id, 'InterventionCreatedEvent', now(), now())";

                        $statement1 = $this->pdo->prepare($querySQL);
                        $statement1->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                        $statement1->bindValue(':current_technician_id', $current_technician_id, PDO::PARAM_INT);
                        $statement1->bindValue(':admin_id', $admin_id, PDO::PARAM_INT);
                        $statement1->execute();

                        $querySQL = "INSERT INTO
                        intervention_events (intervention_id, technician_id, admin_id, type, created_at, updated_at)
                        VALUES (:intervention_id, :current_technician_id, :admin_id, 'InterventionAssignedEvent', now(), now())";

                        // Prepare the statement
                        $statement2 = $this->pdo->prepare($querySQL);
                        $statement2->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                        $statement2->bindValue(':current_technician_id', $current_technician_id, PDO::PARAM_INT);
                        $statement2->bindValue(':admin_id', $admin_id, PDO::PARAM_INT);
                        $statement2->execute();

                        $this->findInterventionById($intervention_id);


                        $querySQL = "
                            SELECT *
                            FROM users
                            WHERE id=:current_technician_id
                            ";
                        // Prepare the statement
                        $statement5 = $this->pdo->prepare($querySQL);

                        // Bind the limit and offset parameters
                        $statement5->bindValue(':current_technician_id', $current_technician_id);
                        $statement5->execute();
                        $user = $statement5->fetch(PDO::FETCH_ASSOC);

                        if ($user && $user['one_signal_id']) {
                            $this->sendNotificationToUser($user['one_signal_id'], 'New intervention', 'You have just been assigned a new intervention');
                        }

                        // // Return a success response
                        // $response = [
                        //     'status' => 'success',
                        //     'message' => 'Intervention created successfully.'
                        // ];
                    } else {

                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                        // Return an error response
                        // $response = [
                        //     'status' => 'error',
                        //     'message' => 'Failed to create intervention.'
                        // ];
                    }

                    // Return the response as JSON
                    // header('Content-Type: application/json');
                    // echo json_encode($response);
                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }
    }

    function sendNotificationToUser($playerId, $title, $message)
    {
        $fields = [
            'app_id' => "f37f93a5-65d6-4fe6-9c68-e45e34f9e21e",
            'include_player_ids' => [$playerId], // Send to the assigned user's player ID
            'headings' => ["en" => $title],
            'contents' => ["en" => $message],
            'data' => ["additionalData" => "New intervention created"],
        ];

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic NWYzYWFlYjItMzg1Mi00Y2UyLWFhNzYtYTdiODM4MDQ3NWE2'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }
    private function findInterventionById($id)
    {
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        // $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        // $searchQuery = isset($_GET['query']) ? $_GET['query'] : '';
        // $rowsPerPage = 60;
        // $offset = ($page - 1) * $rowsPerPage;

        $querySQL = "
            SELECT i.id AS intervention_id,
        i.admin_comment,
        i.urgent,
        i.viewed_by_technician,
        i.viewed_by_support_technician,
        i.viewed_by_admin,
        i.report,
        i.report_digital_signature,
        issue.id AS issue_id,
        issue.name AS issue_name,
        issue.position AS issue_position,
            plant.id AS plant_id,
        plant.street AS plant_street,
        plant.number AS plant_number,
        plant.cap AS plant_cap,
        plant.city AS plant_city,
        plant.country AS plant_country,
        plant.contract AS plant_contract,
        plant.matriculation AS plant_matriculation,
        plant.code AS plant_code,
        plant.latitude AS plant_latitude,
        plant.longitude AS plant_longitude,
        tech.id AS technician_id,
        tech.name AS technician_name,
        tech.surname AS technician_surname,
        supp_tech.id AS support_technician_id,
        supp_tech.name AS support_technician_name,
        supp_tech.surname AS support_technician_surname,
        comp.id AS company_id,
        comp.name AS company_name,
        comp.phone AS company_phone,
        comp.logo AS company_logo,
        comp.street AS company_street,
        comp.number AS company_number,
        comp.city AS company_city,
        comp.cap AS company_cap,
        comp.province AS company_province,
        comp.country AS company_country
            FROM interventions i
            LEFT JOIN issues issue ON i.issue_id = issue.id
            LEFT JOIN plants plant ON i.plant_id = plant.id
            LEFT JOIN users tech ON i.current_technician_id = tech.id
            LEFT JOIN users supp_tech ON i.current_support_technician_id = supp_tech.id
            LEFT JOIN notes ON i.id = notes.intervention_id
            LEFT JOIN companies comp ON i.company_id = comp.id
            WHERE i.id=:id ";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_STR);
        $statement->bindValue(':id', $id, PDO::PARAM_STR);
        //  $statement->bindValue(':searchQuery', '%' . $searchQuery . '%', PDO::PARAM_STR);
        //  $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        //  $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        //$interventions = [];
        //foreach ($results as $row) {
        // Prepare the intervention data
        $intervention = [
            'id' => $row['intervention_id'],
            'admin_comment' => $row['admin_comment'],
            'urgent' => $row['urgent'] == 1,
            'viewed_by_technician' => $row['viewed_by_technician'] == 1,
            'viewed_by_support_technician' => $row['viewed_by_support_technician'] == 1,
            'viewed_by_admin' => $row['viewed_by_admin'] == 1,
            'notes' => [], // Assuming notes are fetched elsewhere
            'technician_distance_from_plant' => null, // Set this if you have the data
            'issue' => [
                'id' => $row['issue_id'],
                'name' => $row['issue_name'],
                'position' => $row['issue_position']
            ],
            'plant' => [
                'id' => $row['plant_id'],
                'address' => $row['plant_street'] . ' ' . $row['plant_number'] . ', ' . $row['plant_cap'] . ' ' . $row['plant_city'] . ', ' . $row['plant_city'] . ', ' . $row['plant_country'],
                'street' => $row['plant_street'],
                'number' => $row['plant_number'],
                'cap' => $row['plant_cap'],
                'city' => $row['plant_city'],
                'detail' => '',
                'contract' => $row['plant_contract'],
                'matriculation' => $row['plant_matriculation'],
                'code' => $row['plant_code'],
                'streetview_url' => 'https://maps.googleapis.com/maps/api/streetview?size=506x248&location=' . $row['plant_street'] . ' ' . $row['plant_number'] . ', ' . $row['plant_cap'] . ' ' . $row['plant_city'] . ', ' . $row['plant_city'] . ', ' . $row['plant_country'] . '&key=' . $this->GOOGLE_MAPS_API_KEY
            ],
            'current_technician' => [
                'id' => $row['technician_id'],
                'name' => $row['technician_name'],
                'surname' => $row['technician_surname'],
                'type' => 'technician'
            ],
            'current_support_technician' => $row['support_technician_id'] ? [
                'id' => $row['support_technician_id'],
                'name' => $row['support_technician_name'],
                'surname' => $row['support_technician_surname'],
                'type' => 'support_technician'
            ] : null,
            // 'intervention_events' => [
            //     [
            //         'id' => $row['event_id'],
            //         'intervention_id' => $row['intervention_id'],
            //         'technician_id' => $row['technician_id'],
            //         'support_technician_id' => $row['support_technician_id'],
            //         'admin_id' => 54, // Replace with actual admin ID
            //         'type' => $row['event_type'],
            //         'created_at' => $row['event_created_at']
            //     ]
            // ],
            'type' => 'OpenIntervention', // Adjust this as needed
            'report' => $row['report'], // Set this if you have the data
            'report_digital_signature' => $row['report_digital_signature'], // Set this if you have the data
            'company' => [
                'id' => $row['company_id'],
                'name' => $row['company_name'],
                'address' => [
                    'street' => $row['company_street'],
                    'number' => $row['company_number'],
                    'city' => $row['company_city'],
                    'cap' => $row['company_cap'],
                    'province' => $row['company_province'],
                    'country' => $row['company_country']
                ],
                'logo' => $row['company_logo'],
                'phone' => $row['company_phone']
            ]
        ];

        // $intervention['notes'] = [];
        $intervention_id = $row['intervention_id'];
        $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS note_created_at FROM notes WHERE intervention_id = :intervention_id");
        $stmt->bindParam(':intervention_id', $intervention_id);
        $stmt->execute();
        $notesData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($notesData as $noterow) {
            $note = [
                'id' => $noterow['id'],
                'title' => $noterow['title'],
                'text' => $noterow['text'],
                'viewed_by_admin' => $noterow['viewed_by_admin'],
                'technician_id' => $noterow['technician_id'],
                'created_at' => $noterow['note_created_at'],
                'photos' => [] // Initialize the photos array
            ];


            $note_id = $noterow['id'];
            $stmt = $this->pdo->prepare("SELECT * FROM photos WHERE note_id = :note_id");
            $stmt->bindParam(':note_id', $note_id);
            $stmt->execute();
            $photosData = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($photosData as $photorow) {
                $note['photos'][] = [
                    'id' => $photorow['id'],
                    'url' => $this->SITE_URL . '/uploads/photo/data/' . $photorow['id'] . '/' . $photorow['data']
                ];
            }
            $intervention['notes'][] = $note;

        }

        $intervention['intervention_events'] = [];
        $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id");
        $stmt->bindParam(':intervention_id', $id);
        $stmt->execute();
        $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($eventsData as $eventrow) {
            $intervention['intervention_events'][] = [
                'id' => $eventrow['id'],
                'intervention_id' => $eventrow['intervention_id'],
                'technician_id' => $eventrow['technician_id'],
                'admin_id' => $eventrow['admin_id'],
                'type' => $eventrow['type'],
                'created_at' => $eventrow['event_created_at'],
            ];
        }

        // Append the intervention to the interventions array
        //     $interventions[] = $intervention;
        // }
        // return $intervention;
        $json = json_encode($intervention, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
    }
    public function createEvent()
    {
        // Check if the request method is POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    $companyObject = $this->currentUserCompany;
                    $company_id = $companyObject['id'];
                    $intervention_id = isset($postData['intervention_id']) ? (int) $postData['intervention_id'] : null;
                    $technician_id = isset($postData['technician_id']) ? (int) $postData['technician_id'] : null;
                    $type = isset($postData['type']) ? $postData['type'] : '';

                    $querySQL = "INSERT INTO
                        intervention_events (intervention_id, technician_id, type, created_at, updated_at)
                       VALUES (:intervention_id, :technician_id, :type, now(), now())";

                    // Prepare the statement
                    $statement = $this->pdo->prepare($querySQL);

                    // Bind the parameters
                    $statement->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                    $statement->bindValue(':technician_id', $technician_id, PDO::PARAM_INT);
                    $statement->bindValue(':type', $type, PDO::PARAM_STR);

                    // // For debugging: echo the query with bound values
                    // $queryWithValues = str_replace(
                    //     [':admin_comment', ':current_technician_id', ':issue_id', ':plant_id', ':urgent', ':company_id'],
                    //     [$admin_comment, $current_technician_id, $issue_id, $plant_id, $urgent, $company_id],
                    //     $querySQL
                    // );
                    // echo "SQL Query: " . $queryWithValues . "<br>";

                    // Execute the query
                    if ($statement->execute()) {

                        if ($type == 'InterventionDeclinedEvent') {
                            $querySQL = "UPDATE interventions SET created_at=now(), updated_at=now(), type='RefusedIntervention' where id=:intervention_id";
                            // Prepare the statement
                            $statement0 = $this->pdo->prepare($querySQL);
                            $statement0->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                            $statement0->execute();
                        } else if ($type == 'InterventionPausedEvent') {
                            $querySQL = "UPDATE interventions SET created_at=now(), updated_at=now(), type='WaitingIntervention' where id=:intervention_id";
                            // Prepare the statement
                            $statement0 = $this->pdo->prepare($querySQL);
                            $statement0->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                            $statement0->execute();
                        }

                        // Return a success response
                        // $response = [
                        //     'status' => 'success',
                        //     'message' => 'Intervention Event created successfully.'
                        // ];

                        $intervention_events = [];
                        $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS event_created_at FROM intervention_events WHERE intervention_id = :intervention_id");
                        $stmt->bindParam(':intervention_id', $intervention_id);
                        $stmt->execute();
                        $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($eventsData as $eventrow) {
                            $intervention_events = [
                                'id' => $eventrow['id'],
                                'intervention_id' => $eventrow['intervention_id'],
                                'technician_id' => $eventrow['technician_id'],
                                'admin_id' => $eventrow['admin_id'],
                                'type' => $eventrow['type'],
                                'created_at' => $eventrow['event_created_at'],
                            ];
                        }

                        // Append the intervention to the interventions array
                        //     $interventions[] = $intervention;
                        // }
                        // return $intervention;
                        $json = json_encode($intervention_events, JSON_PRETTY_PRINT);
                        header('Content-Type: application/json');
                        echo $json;

                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create intervention event.'
                        ];
                        // Return the response as JSON
                        header('Content-Type: application/json');
                        echo json_encode($response);
                    }


                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }
    }
    public function createNote()
    {
        // Check if the request method is POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    // $companyObject = $this->currentUserCompany;
                    // $company_id = $companyObject['id'];
                    $title = isset($postData['title']) ? $postData['title'] : '';
                    $text = isset($postData['text']) ? $postData['text'] : '';
                    $viewed_by_admin = isset($postData['viewed_by_admin']) ? $postData['viewed_by_admin'] : false;
                    $intervention_id = isset($postData['intervention_id']) ? $postData['intervention_id'] : null;
                    $technician_id = isset($postData['technician_id']) ? $postData['technician_id'] : null;
                    $deadline_id = isset($postData['deadline_id']) ? $postData['deadline_id'] : null;


                    $querySQL = "INSERT INTO
                        notes (title, text, viewed_by_admin, technician_id,intervention_id, deadline_id, created_at, updated_at)
                       VALUES (:title, :text, :viewed_by_admin, :technician_id,:intervention_id, :deadline_id, now(), now())";

                    // Prepare the statement
                    $statement = $this->pdo->prepare($querySQL);

                    // Bind the parameters
                    $statement->bindValue(':title', $title, PDO::PARAM_STR);
                    $statement->bindValue(':text', $text, PDO::PARAM_STR);
                    $statement->bindValue(':viewed_by_admin', $viewed_by_admin);
                    $statement->bindValue(':intervention_id', $intervention_id, PDO::PARAM_INT);
                    $statement->bindValue(':technician_id', $technician_id, PDO::PARAM_INT);
                    $statement->bindValue(':deadline_id', $deadline_id);


                    // // For debugging: echo the query with bound values
                    // $queryWithValues = str_replace(
                    //     [':admin_comment', ':current_technician_id', ':issue_id', ':plant_id', ':urgent', ':company_id'],
                    //     [$admin_comment, $current_technician_id, $issue_id, $plant_id, $urgent, $company_id],
                    //     $querySQL
                    // );
                    // echo "SQL Query: " . $queryWithValues . "<br>";

                    // Execute the query
                    if ($statement->execute()) {

                        // Return a success response
                        // $response = [
                        //     'status' => 'success',
                        //     'message' => 'Intervention Event created successfully.'
                        // ];
                        $lastInsertId = $this->pdo->lastInsertId();
                        $intervention_events = [];
                        $stmt = $this->pdo->prepare("SELECT *, DATE_FORMAT(created_at, '%d/%m/%Y %H:%i:%s') AS note_created_at FROM notes WHERE id = :lastInsertId");
                        $stmt->bindParam(':lastInsertId', $lastInsertId);
                        $stmt->execute();
                        $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($eventsData as $eventrow) {
                            $intervention_events = [
                                'id' => $eventrow['id'],
                                'title' => $eventrow['title'],
                                'text' => $eventrow['text'],
                                'viewed_by_admin' => $eventrow['viewed_by_admin'],
                                'technician_id' => $eventrow['technician_id'],
                                'intervention_id' => $eventrow['intervention_id'],
                                'created_at' => $eventrow['note_created_at'],
                                'deadline_id' => $eventrow['deadline_id'],
                            ];
                        }

                        // Append the intervention to the interventions array
                        //     $interventions[] = $intervention;
                        // }
                        // return $intervention;
                        $json = json_encode($intervention_events, JSON_PRETTY_PRINT);
                        header('Content-Type: application/json');
                        echo $json;

                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create note.'
                        ];
                        // Return the response as JSON
                        header('Content-Type: application/json');
                        echo json_encode($response);
                    }


                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }
    }

    public function uploadPhoto($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $input = file_get_contents('php://input');
            $data = json_decode($input, true);
            // Check if 'image' data is provided
            if (isset($data['data'])) {
                $imageData = $data['data'];

                // Extract the base64 data part
                list($type, $imageData) = explode(';', $imageData);
                list(, $imageData) = explode(',', $imageData);

                // Decode the base64 data
                $decodedData = base64_decode($imageData);
                $fileName = 'data.jpeg';
                $stmt = $this->pdo->prepare("INSERT INTO `notes`(`intervention_id`,`created_at`, `updated_at`) VALUES (:id,
                now(),
                now())");
                $stmt->bindParam(':id', $id);
                $stmt->execute();
                $note_id = $this->pdo->lastInsertId();

                $stmt = $this->pdo->prepare("INSERT INTO `photos`(`note_id`, `data`, `created_at`, `updated_at`) VALUES (:note_id, :photo,
                now(),
                now())");
                $stmt->bindParam(':photo', $fileName);
                $stmt->bindParam(':note_id', $note_id);
                $stmt->execute();
                $image_id = $this->pdo->lastInsertId();

                // Define the directory to save the photo
                $uploadDir = __DIR__ . '/../uploads/photo/data/' . $image_id . '/';
                if (!file_exists($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }

                // Save the image with a unique filename

                $filePath = $uploadDir . $fileName;

                if (file_put_contents($filePath, $decodedData)) {

                    // Return success response
                    echo json_encode(['status' => 'success', 'message' => 'Photo uploaded successfully!', 'file' => $fileName]);
                } else {
                    // Return error response if saving the file fails
                    echo json_encode(['status' => 'error', 'message' => 'Failed to save the photo.']);
                }
            } else {
                // Return error response if the image is missing
                echo json_encode(['status' => 'error', 'message' => 'No image data provided.']);
            }
        } else {
            // Return error response for non-POST requests
            echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
        }
    }
}
