<?php
require_once __DIR__ . '/../helpers/response.php';
// require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';
class CompaniesController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->checkIfSupperAdmin()) {
            exit; // Stop further script execution
        }
    }

    public function index()
    {
        // $companyObject = $this->currentUserCompany;
        // $company_id = $companyObject['id'];
        // $allow_inactive = isset($_GET['allow_inactive']) ? true : false;

        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;


        $sql = "SELECT * FROM  companies WHERE is_usable = true ";

        // $sql .= "  LIMIT :limit OFFSET :offset";

        $statement = $this->pdo->prepare($sql);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        // if ($maintainer_id) {
        //     $statement->bindValue(':maintainer_id', $maintainer_id, PDO::PARAM_INT);
        // }

        // $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        // $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);
        $CompaniesData = [];
        foreach ($results as $row) {
            $company_id = $row['id'];
            $stmt = $this->pdo->prepare("SELECT count(id) as admins_count FROM users WHERE  company_id = :company_id and type='Admin' and is_usable = true ");
            $stmt->bindParam(':company_id', $company_id);
            ;
            $stmt->execute();
            $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
            $admins_count = $plantsData['admins_count'];

            $stmt = $this->pdo->prepare("SELECT count(id) as technicians_count FROM users WHERE  company_id = :company_id and type='Technician' and is_usable = true ");
            $stmt->bindParam(':company_id', $company_id);
            ;
            $stmt->execute();
            $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
            $technicians_count = $plantsData['technicians_count'];

            $companyData = $row;

            $companyData['admins_count'] = $admins_count;
            $companyData['technicians_count'] = $technicians_count;

            $CompaniesData[] = $companyData;

        }


        $json = json_encode($CompaniesData, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    // $companyObject = $this->currentUserCompany;

                    // $company_id = isset($postData['company_id']) ? $postData['company_id'] : '';
                    // $email = isset($postData['email']) ? $postData['email'] : '';

                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    $number = isset($postData['number']) ? $postData['number'] : '';
                    $province = isset($postData['province']) ? $postData['province'] : '';
                    $street = isset($postData['street']) ? $postData['street'] : '';
                    $cap = isset($postData['cap']) ? $postData['cap'] : '';
                    $city = isset($postData['city']) ? $postData['city'] : '';
                    $country = isset($postData['country']) ? $postData['country'] : '';
                    //$logo = isset($postData['logo']) ? $postData['logo'] : '';



                    $sql = "INSERT INTO companies (name, number, phone, province, street, cap,city, country, created_at, updated_at) 
                VALUES (:name, :number, :phone, :province, :street, :cap, :city, :country, now(), now())";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':number', $number, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    $statement->bindValue(':province', $province, PDO::PARAM_STR);
                    $statement->bindValue(':street', $street, PDO::PARAM_INT);
                    $statement->bindValue(':cap', $cap, PDO::PARAM_STR);
                    $statement->bindValue(':city', $city, PDO::PARAM_STR);
                    $statement->bindValue(':country', $country, PDO::PARAM_STR);
                    if ($statement->execute()) {
                        // Assuming sendWelcomeMail() and sendResetPasswordInstructions() are functions defined elsewhere
                        $company_id = $this->pdo->lastInsertId();

                        $technician = $this->findCompanyById($company_id);
                        header('Content-Type: application/json');
                        echo json_encode($technician);
                        // http_response_code(201);
                    } else {
                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                    }
                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }
    private function findCompanyById($id)
    {

        $sql = "SELECT * FROM companies WHERE is_usable = true and id=:id ";

        $statement = $this->pdo->prepare($sql);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->bindValue(':id', $id, PDO::PARAM_INT);

        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        return $row;
    }

    public function update($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'PATCH') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    //$companyObject = $this->currentUserCompany;
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    $number = isset($postData['number']) ? $postData['number'] : '';
                    $province = isset($postData['province']) ? $postData['province'] : '';
                    $street = isset($postData['street']) ? $postData['street'] : '';
                    $cap = isset($postData['cap']) ? $postData['cap'] : '';
                    $city = isset($postData['city']) ? $postData['city'] : '';
                    $country = isset($postData['country']) ? $postData['country'] : '';




                    $sql = "UPDATE companies set name=:name, phone=:phone, number=:number, province=:province, street=:street, cap=:cap, city=:city, country=:country, updated_at=now() 
                    WHERE id = :id
                    ";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    $statement->bindValue(':number', $number, PDO::PARAM_STR);
                    $statement->bindValue(':province', $province, PDO::PARAM_STR);
                    $statement->bindValue(':street', $street, PDO::PARAM_STR);
                    $statement->bindValue(':cap', $cap, PDO::PARAM_STR);
                    $statement->bindValue(':city', $city, PDO::PARAM_STR);
                    $statement->bindValue(':country', $country, PDO::PARAM_STR);
                    $statement->bindValue(':id', $id, PDO::PARAM_STR);
                    if ($statement->execute()) {
                        // Return a success response
                        $response = [
                            'status' => 'success',
                            'message' => 'company updated successfully.'
                        ];
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create intervention.'
                        ];
                    }
                    // Return the response as JSON
                    header('Content-Type: application/json');
                    echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }

    public function distroy($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
            //$companyObject = $this->currentUserCompany;
            //$company_id = $companyObject['id'];

            $sql = "UPDATE companies SET is_usable = false WHERE id = :id";
            // $sql = "DELETE FROM companies WHERE id = :id";

            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Admin deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create intervention.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }

    public function getCompanyById($id)
    {

        $stmt = $this->pdo->prepare("SELECT * FROM companies
        WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $companyData = $stmt->fetch(PDO::FETCH_ASSOC);

        $companyData['address'] = [
            'street' => $companyData['street'],
            'number' => $companyData['number'],
            'city' => $companyData['city'],
            'cap' => $companyData['cap'],
            'province' => $companyData['province'],
            'country' => $companyData['country']
        ];

        $company_id = $companyData['id'];
        $stmt = $this->pdo->prepare("SELECT count(id) as admins_count FROM users WHERE  company_id = :company_id and type='Admin' and is_usable = true ");
        $stmt->bindParam(':company_id', $company_id);
        ;
        $stmt->execute();
        $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
        $admins_count = $plantsData['admins_count'];

        $stmt = $this->pdo->prepare("SELECT count(id) as technicians_count FROM users WHERE  company_id = :company_id and type='Technician' and is_usable = true ");
        $stmt->bindParam(':company_id', $company_id);
        ;
        $stmt->execute();
        $plantsData = $stmt->fetch(PDO::FETCH_ASSOC);
        $technicians_count = $plantsData['technicians_count'];



        $companyData['admins_count'] = $admins_count;
        $companyData['technicians_count'] = $technicians_count;


        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE company_id = :company_id ");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->execute();
        $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $companyData['admins'] = [];
        foreach ($eventsData as $eventrow) {
            $companyData['admins'][] = [
                'id' => $eventrow['id'],
                'name' => $eventrow['name'],
                'surname' => $eventrow['surname'],
                'email' => $eventrow['email'],
                'phone' => $eventrow['phone']
            ];
        }


        $jsonOutput = json_encode($companyData);

        header('Content-Type: application/json');
        echo $jsonOutput;
    }

    public function getUsersByCompanyId($id, $user_type)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE company_id = :company_id and type = :user_type ");
        $stmt->bindParam(':company_id', $id);
        $stmt->bindParam(':user_type', $user_type);
        $stmt->execute();
        $eventsData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $companyData = [];
        foreach ($eventsData as $eventrow) {
            $companyData[] = [
                'id' => $eventrow['id'],
                'name' => $eventrow['name'],
                'surname' => $eventrow['surname'],
                'email' => $eventrow['email'],
                'phone' => $eventrow['phone']
            ];
        }


        $jsonOutput = json_encode($companyData);

        header('Content-Type: application/json');
        echo $jsonOutput;
    }

    protected function checkIfSupperAdmin()
    {
        $uid = isset($_SERVER['HTTP_UID']) ? $_SERVER['HTTP_UID'] : "";
        $stmt = $this->pdo->prepare("SELECT * FROM users
        WHERE email = :email");
        $stmt->bindParam(':email', $uid);
        $stmt->execute();
        $userData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($userData != null && $userData['type'] == "SuperAdmin") {
            return true;
        } else {
            http_response_code(403);
            $message = 'Soltanto i superadmin possono accedere alle liste di amministratori.';
            echo json_encode(['errors' => [$message]]);
            return false;
        }
    }


}
