<?php
// base_controller.php
class BaseController
{
    protected $pdo;
    protected $currentUser;
    protected $currentUserCompany;
    protected $currentUserGOPosition;
    protected $GOOGLE_MAPS_API_KEY;
    protected $SITE_URL;
    protected $SMTP_Host;
    protected $SMTP_Username;
    protected $SMTP_Password;

    public function __construct()
    {
        $this->pdo = require __DIR__ . '/../config/database.php';
        $this->currentUser = $this->currentUser();
        $this->currentUserCompany = $this->currentUserCompany();
        $this->currentUserGOPosition = $this->currentUserGOPosition();
        $this->GOOGLE_MAPS_API_KEY = 'AIzaSyBR1mVV0-CDv6ipxNp24FMq3U7KXE0qRpU';
        $this->SITE_URL = 'https://api.deshsoft.net';
        $this->SMTP_Host = 'smtp.mailgun.org';
        $this->SMTP_Username = 'postmaster@notifications.vuala.me';
        $this->SMTP_Password = '3ec0537fb672dca45001b6930e3ccadf-6140bac2-903bc7d4';

    }

    protected function currentUser()
    {
        $uid = isset($_SERVER['HTTP_UID']) ? $_SERVER['HTTP_UID'] : "";
        $querySQL = "
            SELECT *
            FROM users
            WHERE uid=:email
            ";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters
        $statement->bindValue(':email', $uid, PDO::PARAM_STR);
        $statement->execute();
        $user = $statement->fetch(PDO::FETCH_ASSOC);
        // Implement your logic to return the current authenticated user
        // Example: return $_SESSION['user'];
        return $user;
    }
    protected function currentUserCompany()
    {
        $uid = isset($_SERVER['HTTP_UID']) ? $_SERVER['HTTP_UID'] : "";
        $querySQL = "
            SELECT comp.*
            FROM users u 
            INNER JOIN companies comp ON u.company_id = comp.id
            LEFT JOIN geographic_coordinates g ON u.id = g.technician_id
            WHERE u.uid=:email
            ";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters
        $statement->bindValue(':email', $uid, PDO::PARAM_STR);
        $statement->execute();
        $company = $statement->fetch(PDO::FETCH_ASSOC);
        // Implement your logic to return the current authenticated user
        // Example: return $_SESSION['user'];
        return $company;
    }

    protected function currentUserGOPosition()
    {
        $uid = isset($_SERVER['HTTP_UID']) ? $_SERVER['HTTP_UID'] : "";
        $querySQL = "
            SELECT g.*
            FROM users u 
            LEFT JOIN geographic_coordinates g ON u.id = g.technician_id
            WHERE u.uid=:email
            order by g.id desc limit 1
            ";
        // Prepare the statement
        $statement = $this->pdo->prepare($querySQL);

        // Bind the limit and offset parameters
        $statement->bindValue(':email', $uid, PDO::PARAM_STR);
        $statement->execute();
        $go = $statement->fetch(PDO::FETCH_ASSOC);
        // Implement your logic to return the current authenticated user
        // Example: return $_SESSION['user'];
        return $go;
    }

    function haversineDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371)
    {
        // echo $latitudeFrom . ' ';
        // echo $longitudeFrom . ' ';
        // echo $latitudeTo . ' ';
        // echo $longitudeTo . ' ';
        // die;

        // Convert input values to float
        $latitudeFrom = floatval($latitudeFrom);
        $longitudeFrom = floatval($longitudeFrom);
        $latitudeTo = floatval($latitudeTo);
        $longitudeTo = floatval($longitudeTo);

        // Convert from degrees to radians
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);

        // Haversine formula
        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;


        $a = sin($latDelta / 2) * sin($latDelta / 2) +
            cos($latFrom) * cos($latTo) *
            sin($lonDelta / 2) * sin($lonDelta / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

        $distance = $earthRadius * $c;

        // $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
        //     cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        // $distance = $angle * $earthRadius;

        return $distance; // Distance in kilometers
    }
}
