<?php

//require_once __DIR__ . '/../models/User.php';
require_once __DIR__ . '/../helpers/response.php';
require_once __DIR__ . '/../config/database.php';
class AuthController
{
    private $pdo;
    public function __construct()
    {
        $this->pdo = require __DIR__ . '/../config/database.php';
    }
    public function signIn($data)
    {
        $email = $data['HTTP_EMAIL'] ?? $data['email'] ?? null;
        $password = $data['HTTP_PASSWORD'] ?? $data['password'] ?? null;
        $userClass = $data['HTTP_USER_CLASS'] ?? $data['user-class'] ?? null;
        $appVersion = $data['HTTP_APP_VERSION'] ?? $data['app-version'] ?? null;
        $oneSignalId = null;
        $contentType = $data['CONTENT_TYPE'] ?? '';
        if ($contentType == 'application/json') {
            // For JSON requests, get raw POST data
            $rawData = file_get_contents('php://input');
            $jsondata = json_decode($rawData, true); // Decode JSON data
            $oneSignalId = $jsondata['one_signal_id'] ?? null;
        }

        if (!$email || !$password || !$userClass) {
            sendResponse(400, 'Missing required fields');
            return;
        }

        // $user = new User();
        $stmt = $this->pdo->prepare("SELECT * FROM users
         WHERE email = :email");
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        $userData = $stmt->fetch(PDO::FETCH_ASSOC);

        $company_id = $userData['company_id'];
        $stmt = $this->pdo->prepare("SELECT * FROM companies WHERE id = :id");
        $stmt->bindParam(':id', $company_id);
        $stmt->execute();
        $comData = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($comData != null) {
            $comData['address'] = [
                'street' => $comData['street'],
                'number' => $comData['number'],
                'city' => $comData['city'],
                'cap' => $comData['cap'],
                'province' => $comData['province'],
                'country' => $comData['country']
            ];
            $userData['company'] = $comData;
        }

        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id");
        $stmt->bindParam(':technician_id', $user_id);
        $stmt->execute();
        $posData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['position'] = $posData;

        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM technician_levels WHERE company_id = :company_id");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->execute();
        $techData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['technician_level'] = $techData;
        $userData['distance_from_plant'] = null;
        $userData['open_interventions_count'] = 0;
        $userData['closed_interventions_count'] = 0;

        //$userData = $user->findByEmail($email);
        // print_r($userData);

        if (!$userData || !password_verify($password, $userData['encrypted_password'])) {
            sendLoginError(401, 'Invalid credentials');
            return;
        }

        if ($oneSignalId != null) {
            $querySQL = "UPDATE users SET one_signal_id=:one_signal_id WHERE email = :email";

            // Prepare the statement
            $statement0 = $this->pdo->prepare($querySQL);
            $statement0->bindParam(':email', $email);
            $statement0->bindParam(':one_signal_id', $oneSignalId);
            $statement0->execute();
        }

        $jsonOutput = json_encode($userData, JSON_PRETTY_PRINT);

        // Output JSON
        header('Content-Type: application/json');
        // header('access-token: gdsewwsdsadfsaere');
        // header('client: asdfsadfasdasdfasdfs');
        // header('token-type: Bearer');
        //header('expiry: application/json');
        header('uid: ' . $email);
        // header('Email: ' . $email);
        echo $jsonOutput;

        // Successful sign-in logic here
        // sendResponse(200, 'Sign in successful', ['user' => $userData]);
    }
    public function signOut($data)
    {
        //  print_r($data);
        //  $access_tocken = $data['HTTP_ACCESS_TOCKEN'] ?? null;
        //  $client = $data['HTTP_CLIENT'] ?? null;

        $email = $data['HTTP_UID'] ?? $data['uid'] ?? null;
        //echo $email;
        // $password = $data['HTTP_PASSWORD'] ?? $data['password'] ?? null;
        // $userClass = $data['HTTP_USER_CLASS'] ?? $data['user-class'] ?? null;
        // $appVersion = $data['HTTP_APP_VERSION'] ?? $data['app-version'] ?? null;
        // if (!$email || !$password || !$userClass) {
        //     sendResponse(400, 'Missing required fields');
        //     return;
        // }


        // Output JSON
        header('Content-Type: application/json');
        //header('access-token: gdsewwsdsadfsaere');
        //header('client: asdfsadfasdasdfasdfs');
        //header('token-type: Bearer');
        //header('expiry: application/json');
        //header('uid: ' . $email);
        // echo $jsonOutput;

        // Successful sign-in logic here
        // sendResponse(200, 'Sign in successful', ['user' => $userData]);
    }
}
