<?php
require_once __DIR__ . '/../helpers/response.php';
// require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/BaseController.php';

require '../PHPMailer/src/Exception.php';
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
class AdminsController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->checkIfSupperAdmin()) {
            exit; // Stop further script execution
        }
    }


    public function index()
    {

        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $rowsPerPage = 60;
        $offset = ($page - 1) * $rowsPerPage;


        $sql = "SELECT u.id,
        u.name,
        u.nickname,
        u.email,
        u.surname,
        u.phone,
        u.birthdate,
        u.role,
        u.speciality,
        u.current_state,
        u.type,
         comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
        FROM users u
        LEFT JOIN companies comp ON u.company_id = comp.id
        WHERE u.type='Admin' AND u.is_usable = true";
        $sql .= "  LIMIT :limit OFFSET :offset";

        $statement = $this->pdo->prepare($sql);

        $statement->bindValue(':limit', $rowsPerPage, PDO::PARAM_INT);
        $statement->bindValue(':offset', $offset, PDO::PARAM_INT);
        $statement->execute();
        $results = $statement->fetchAll(PDO::FETCH_ASSOC);

        $plants = [];
        foreach ($results as $row) {

            $plant = [
                'id' => $row['id'],
                'name' => $row['name'],
                'nickname' => $row['nickname'],
                'email' => $row['email'],
                'surname' => $row['surname'],
                'phone' => $row['phone'],
                'birthdate' => $row['birthdate'],
                'role' => $row['role'],
                'speciality' => $row['speciality'],
                'current_state' => $row['current_state'],
                'type' => $row['type'],


                'company' => [
                    'id' => $row['company_id'],
                    'name' => $row['company_name'],
                    'address' => [
                        'street' => $row['company_street'],
                        'number' => $row['company_number'],
                        'city' => $row['company_city'],
                        'cap' => $row['company_cap'],
                        'province' => $row['company_province'],
                        'country' => $row['company_country']
                    ],
                    'logo' => $row['company_logo'],
                    'phone' => $row['company_phone']
                ]
            ];

            $plants[] = $plant;
        }
        $json = json_encode($plants, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        echo $json;
        return;
    }

    public function create()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    // $companyObject = $this->currentUserCompany;
                    $company_id = isset($postData['company_id']) ? $postData['company_id'] : '';
                    $email = isset($postData['email']) ? $postData['email'] : '';
                    $password = isset($postData['password']) ? $postData['password'] : '';
                    $password_confirmation = isset($postData['password_confirmation']) ? $postData['password_confirmation'] : '';
                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    $speciality = isset($postData['speciality']) ? $postData['speciality'] : '';
                    $surname = isset($postData['surname']) ? $postData['surname'] : '';
                    // $technician_level_id = isset($postData['technician_level_id']) ? (int) $postData['technician_level_id'] : null;

                    if ($password !== $password_confirmation) {
                        echo json_encode(['errors' => ['Password confirmation does not match']]);
                        http_response_code(422);
                        return;
                    }

                    $sql = "INSERT INTO users (name, surname, phone, speciality, company_id, email,uid, encrypted_password, created_at, updated_at, current_state, type) 
                VALUES (:name, :surname, :phone, :speciality, :company_id, :email, :uid, :password, now(), now(), 'free', 'Admin')";

                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':surname', $surname, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    $statement->bindValue(':speciality', $speciality, PDO::PARAM_STR);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    $statement->bindValue(':email', $email, PDO::PARAM_STR);
                    $statement->bindValue(':uid', $email, PDO::PARAM_STR);
                    $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    if ($statement->execute()) {
                        // Assuming sendWelcomeMail() and sendResetPasswordInstructions() are functions defined elsewhere
                        $admin_id = $this->pdo->lastInsertId();
                        $this->sendMail($email, $password, $name);
                        // $this->sendResetPasswordInstructions($email);

                        $technician = $this->findUserById($admin_id);
                        header('Content-Type: application/json');
                        echo json_encode($technician);
                        // http_response_code(201);
                    } else {
                        echo json_encode(['errors' => $statement->errorInfo()]);
                        http_response_code(422);
                    }
                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }
    private function findUserById($id)
    {

        $sql = "SELECT 
            u.id,
        u.name,
        u.nickname,
        u.email,
        u.surname,
        u.phone,
        u.birthdate,
        u.role,
        u.speciality,
        u.current_state,
        u.type,
        t.id AS level_id,
        t.name AS level_name,
         comp.id AS company_id,
                comp.name AS company_name,
                comp.phone AS company_phone,
                comp.logo AS company_logo,
                comp.street AS company_street,
                comp.number AS company_number,
                comp.city AS company_city,
                comp.cap AS company_cap,
                comp.province AS company_province,
                comp.country AS company_country
        FROM users u
         LEFT JOIN companies comp ON u.company_id = comp.id
        LEFT JOIN technician_levels t on t.id = u.technician_level_id
         LEFT JOIN plants p on p.maintainer_id=u.id
        WHERE u.is_usable = true and u.id=:id
        ";


        $statement = $this->pdo->prepare($sql);
        // $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
        $statement->bindValue(':id', $id, PDO::PARAM_INT);

        $statement->execute();
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        $plant = [
            'id' => $row['id'],
            'name' => $row['name'],
            'nickname' => $row['nickname'],
            'email' => $row['email'],
            'surname' => $row['surname'],
            'phone' => $row['phone'],
            'birthdate' => $row['birthdate'],
            'role' => $row['role'],
            'speciality' => $row['speciality'],
            'current_state' => $row['current_state'],
            'type' => $row['type'],
            'company' => [
                'id' => $row['company_id'],
                'name' => $row['company_name'],
                'address' => [
                    'street' => $row['company_street'],
                    'number' => $row['company_number'],
                    'city' => $row['company_city'],
                    'cap' => $row['company_cap'],
                    'province' => $row['company_province'],
                    'country' => $row['company_country']
                ],
                'logo' => $row['company_logo'],
                'phone' => $row['company_phone']
            ]
        ];

        return $plant;
    }



    function sendMail($email, $password, $name)
    {
        // Determine if HTTPS is being used
        $scheme = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';

        // Get the host name (e.g., www.vuala.com)
        $host = $_SERVER['HTTP_ORIGIN'];

        // Define the subject of the email
        $subject = "Welcome to Vuala";

        // Create the HTML message
        $message = "
            <html>
            <head>
                <title>Welcome to Vuala</title>
            </head>
            <body>
                <h2>Welcome to Vuala!</h2>
                <p>Dear user,</p>
                <p>Thank you for registering with Vuala. Below are your login details:</p>
                <table>
                    <tr>
                        <td><strong>Username (Email):</strong></td>
                        <td>{$email}</td>
                    </tr>
                    <tr>
                        <td><strong>Password:</strong></td>
                        <td>{$password}</td>
                    </tr>
                </table>
                <p>You can log in to your account by clicking the link below:</p>
                <p><a href='{$host}' target='_blank'>Login to Vuala</a></p>
                <p>If you have any questions, feel free to contact our support team.</p>
                <p>Best regards,</p>
                <p>The Vuala Team</p>
            </body>
            </html>
            ";

        // Create a new PHPMailer instance
        $mail = new PHPMailer(true);

        try {
            $mail->isSMTP();                                     // Set mailer to use SMTP
            $mail->Host = $this->SMTP_Host;              // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                            // Enable SMTP authentication
            $mail->Username = $this->SMTP_Username;     // SMTP username
            $mail->Password = $this->SMTP_Password;                 // SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;    // Enable TLS encryption, `PHPMailer::ENCRYPTION_SMTPS` also accepted
            $mail->Port = 587;                              // TCP port to connect to

            // Recipients
            $mail->setFrom('postmaster@notifications.vuala.me', 'Vuala');
            $mail->addAddress($email, $name); // Add a recipient

            // Content
            $mail->isHTML(true);                                // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $message;
            //$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

            $mail->send();
            //   echo 'Message has been sent';
        } catch (Exception $e) {
            //  echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    }


    public function update($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'PATCH') {
            // Check if the Content-Type is application/json
            $contentType = isset($_SERVER['CONTENT_TYPE']) ? trim($_SERVER['CONTENT_TYPE']) : '';

            if (strcasecmp($contentType, 'application/json') === 0) {
                // Get the raw POST data
                $rawData = file_get_contents('php://input');

                // Decode the JSON data
                $postData = json_decode($rawData, true);

                // Check if JSON decoding was successful
                if (json_last_error() === JSON_ERROR_NONE) {
                    // Now you can access your data as an associative array
                    //$companyObject = $this->currentUserCompany;
                    $company_id = isset($postData['company_id']) ? $postData['company_id'] : '';
                    //  $email = isset($postData['email']) ? $postData['email'] : '';

                    $name = isset($postData['name']) ? $postData['name'] : '';
                    $phone = isset($postData['phone']) ? $postData['phone'] : '';
                    //$speciality = isset($postData['speciality']) ? $postData['speciality'] : '';
                    $surname = isset($postData['surname']) ? $postData['surname'] : '';
                    //   $technician_level_id = isset($postData['technician_level_id']) ? (int) $postData['technician_level_id'] : null;
                    $password = isset($postData['password']) ? $postData['password'] : '';
                    $password_confirmation = isset($postData['password_confirmation']) ? $postData['password_confirmation'] : '';

                    if ($password !== $password_confirmation) {
                        echo json_encode(['errors' => ['Password confirmation does not match']]);
                        http_response_code(422);
                        return;
                    }



                    $sql = "UPDATE users set name=:name, surname=:surname, phone=:phone, company_id=:company_id, ";
                    if ($password !== "") {
                        $sql .= " encrypted_password=:password, ";
                    }
                    $sql .= " updated_at=now() WHERE id = :id ";


                    $statement = $this->pdo->prepare($sql);
                    $statement->bindValue(':name', $name, PDO::PARAM_STR);
                    $statement->bindValue(':surname', $surname, PDO::PARAM_STR);
                    $statement->bindValue(':phone', $phone, PDO::PARAM_STR);
                    //$statement->bindValue(':speciality', $speciality, PDO::PARAM_STR);
                    //$statement->bindValue(':technician_level_id', $technician_level_id, PDO::PARAM_INT);
                    $statement->bindValue(':company_id', $company_id, PDO::PARAM_INT);
                    if ($password !== "") {
                        $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    }

                    $statement->bindValue(':id', $id, PDO::PARAM_INT);
                    // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
                    if ($statement->execute()) {
                        // Return a success response
                        $response = [
                            'status' => 'success',
                            'message' => 'Admin updated successfully.'
                        ];
                    } else {
                        // Return an error response
                        $response = [
                            'status' => 'error',
                            'message' => 'Failed to create intervention.'
                        ];
                    }
                    // Return the response as JSON
                    header('Content-Type: application/json');
                    echo json_encode($response);

                } else {
                    // JSON decoding failed
                    header('Content-Type: application/json');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid JSON data'
                    ]);
                }
            } else {
                // The Content-Type is not application/json
                header('Content-Type: application/json');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Content-Type must be application/json'
                ]);
            }
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be POST'
            ]);
        }

    }

    public function distroy($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
            //$companyObject = $this->currentUserCompany;
            //$company_id = $companyObject['id'];

            //$sql = "UPDATE users SET is_usable = false, tokens = '{}' WHERE id = :id";
            $sql = "DELETE FROM users WHERE id = :id";

            $statement = $this->pdo->prepare($sql);

            $statement->bindValue(':id', $id, PDO::PARAM_INT);
            // $statement->bindValue(':password', password_hash($password, PASSWORD_BCRYPT), PDO::PARAM_STR);
            if ($statement->execute()) {
                // Return a success response
                $response = [
                    'status' => 'success',
                    'message' => 'Admin deleted successfully.'
                ];
            } else {
                // Return an error response
                $response = [
                    'status' => 'error',
                    'message' => 'Failed to create intervention.'
                ];
            }
            // Return the response as JSON
            header('Content-Type: application/json');
            echo json_encode($response);
        } else {
            // The request method is not POST
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Request method must be DELETE'
            ]);
        }


    }

    // Returns the complete list of users.
    // If 'allow_inactive=true' param is included, then unusable users will be included too.
    public function getUserById($id)
    {
        $stmt = $this->pdo->prepare("SELECT * FROM users
        WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $userData = $stmt->fetch(PDO::FETCH_ASSOC);
        $company_id = $userData['company_id'];
        $stmt = $this->pdo->prepare("SELECT * FROM companies WHERE id = :id");
        $stmt->bindParam(':id', $company_id);
        $stmt->execute();
        $comData = $stmt->fetch(PDO::FETCH_ASSOC);
        $comData['address'] = [
            'street' => $comData['street'],
            'number' => $comData['number'],
            'city' => $comData['city'],
            'cap' => $comData['cap'],
            'province' => $comData['province'],
            'country' => $comData['country']
        ];
        $userData['company'] = $comData;

        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM geographic_coordinates WHERE technician_id = :technician_id");
        $stmt->bindParam(':technician_id', $user_id);
        $stmt->execute();
        $posData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['position'] = $posData;

        $user_id = $userData['id'];
        $stmt = $this->pdo->prepare("SELECT * FROM technician_levels WHERE company_id = :company_id");
        $stmt->bindParam(':company_id', $company_id);
        $stmt->execute();
        $techData = $stmt->fetch(PDO::FETCH_ASSOC);
        $userData['technician_level'] = $techData;
        $userData['distance_from_plant'] = null;
        $userData['open_interventions_count'] = 0;
        $userData['closed_interventions_count'] = 0;
        $jsonOutput = json_encode($userData);

        header('Content-Type: application/json');
        echo $jsonOutput;
    }

    protected function checkIfSupperAdmin()
    {
        $uid = isset($_SERVER['HTTP_UID']) ? $_SERVER['HTTP_UID'] : "";
        $stmt = $this->pdo->prepare("SELECT * FROM users
        WHERE email = :email");
        $stmt->bindParam(':email', $uid);
        $stmt->execute();
        $userData = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($userData != null && $userData['type'] == "SuperAdmin") {
            return true;
        } else {
            http_response_code(403);
            $message = 'Soltanto i superadmin possono accedere alle liste di amministratori.';
            echo json_encode(['errors' => [$message]]);
            return false;
        }
    }

}
